/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.metamodel.MetaModelBuilder;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.provider.IndexProvider;

public class MetadataIndexEngine
implements MetaIndexEngine {
    private final MetaModelBuilder metaModelBuilder;
    private Logger logger = LoggerFactory.getLogger(MetadataIndexEngine.class);
    private final IndexProvider provider;
    private final Map<KCluster, ReentrantLock> batchLocks = new ConcurrentHashMap<KCluster, ReentrantLock>();
    private final ThreadLocal<Map<KCluster, List<KObject>>> batchSets = ThreadLocal.withInitial(() -> new HashMap());
    private final Collection<Runnable> beforeDispose = new ArrayList<Runnable>();
    private final Consumer<List<KObject>> kObectBatchObserver;

    public MetadataIndexEngine(IndexProvider provider, MetaModelStore metaModelStore, Consumer<List<KObject>> kObectBatchObserver) {
        this.provider = provider;
        this.kObectBatchObserver = kObectBatchObserver;
        this.metaModelBuilder = new MetaModelBuilder(metaModelStore);
        PriorityDisposableRegistry.register((PriorityDisposable)this);
    }

    public boolean freshIndex(KCluster cluster) {
        boolean isFreshIndex;
        boolean bl = isFreshIndex = this.provider.isFreshIndex(cluster) && !this.batchLocks.containsKey(cluster);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Is fresh index? " + isFreshIndex);
        }
        return isFreshIndex;
    }

    public boolean isIndexReady(KCluster cluster) {
        ReentrantLock lock;
        return !this.provider.isFreshIndex(cluster) && (lock = this.batchLocks.get(cluster)) != null && !lock.isLocked();
    }

    public void prepareBatch(KCluster cluster) {
        this.batchLocks.putIfAbsent(cluster, new ReentrantLock());
    }

    public void startBatch(KCluster cluster) {
        this.prepareBatch(cluster);
        Map<KCluster, List<KObject>> batchSet = this.batchSets.get();
        if (batchSet.containsKey(cluster)) {
            throw new IllegalStateException(String.format("Cannot start a batch for cluster [id=%s] when there is already a batch started on this thread [%s]", cluster.getClusterId(), Thread.currentThread().getName()));
        }
        batchSet.put(cluster, new ArrayList());
    }

    public void index(KObject kObject) {
        if (this.isBatch(kObject)) {
            KClusterImpl index = new KClusterImpl(kObject.getClusterId());
            List<KObject> store = this.batchSets.get().get(index);
            store.add(kObject);
        } else {
            this.doIndex(kObject);
        }
    }

    private void doIndex(KObject kObject) {
        this.metaModelBuilder.updateMetaModel(kObject);
        this.provider.index(kObject);
    }

    private boolean isBatch(KObject object) {
        KClusterImpl cluster = new KClusterImpl(object.getClusterId());
        Map<KCluster, List<KObject>> batchSet = this.batchSets.get();
        if (batchSet.isEmpty()) {
            this.batchSets.remove();
        }
        return batchSet.containsKey(cluster);
    }

    public void rename(KObjectKey from, KObject to) {
        PortablePreconditions.checkNotNull((String)"from", (Object)from);
        PortablePreconditions.checkNotNull((String)"to", (Object)to);
        PortablePreconditions.checkCondition((String)"renames are allowed only from same cluster", (boolean)from.getClusterId().equals(to.getClusterId()));
        this.provider.rename(from.getClusterId(), from.getId(), to);
    }

    protected boolean exists(KObjectKey from) {
        return this.provider.exists(from.getClusterId(), from.getId());
    }

    public void delete(KCluster cluster) {
        this.provider.delete(cluster.getClusterId());
    }

    public void delete(KObjectKey objectKey) {
        this.provider.delete(objectKey.getClusterId(), objectKey.getId());
    }

    public void delete(KObjectKey ... objectsKey) {
        Arrays.stream(objectsKey).forEach(kObjectKey -> this.delete((KObjectKey)kObjectKey));
    }

    public void commit(KCluster cluster) {
        this.prepareBatch(cluster);
        ReentrantLock lock = this.batchLocks.get(cluster);
        List<KObject> batchSet = this.batchSets.get().get(cluster);
        try {
            if (batchSet == null) {
                throw new IllegalStateException(String.format("Cannot commit batch for cluster [id=%s] when no batch has been started in thread [%s].", cluster.getClusterId(), Thread.currentThread().getName()));
            }
            if (batchSet.isEmpty()) {
                this.removeThreadLocalBatchState(cluster);
            } else {
                this.doCommit(cluster, batchSet, lock);
            }
        }
        catch (Throwable t) {
            this.abort(cluster);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(KCluster cluster, List<KObject> kobjects, ReentrantLock lock) {
        try {
            lock.lock();
            kobjects.forEach(this::doIndex);
            this.removeThreadLocalBatchState(cluster);
            this.kObectBatchObserver.accept(kobjects);
        }
        finally {
            lock.unlock();
        }
    }

    public void abort(KCluster cluster) {
        this.removeThreadLocalBatchState(cluster);
    }

    private void removeThreadLocalBatchState(KCluster cluster) {
        Map<KCluster, List<KObject>> batchSet = this.batchSets.get();
        batchSet.remove(cluster);
        if (batchSet.isEmpty()) {
            this.batchSets.remove();
        }
    }

    public void beforeDispose(Runnable callback) {
        this.beforeDispose.add((Runnable)PortablePreconditions.checkNotNull((String)"callback", (Object)callback));
    }

    public int priority() {
        return 50;
    }

    public void dispose() {
        if (!this.beforeDispose.isEmpty()) {
            for (Runnable activeDispose : this.beforeDispose) {
                activeDispose.run();
            }
        }
    }
}

