/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.common;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.io.IndexerDispatcher;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.common.util.TestFileSystemProvider;
import org.uberfire.java.nio.base.FSPath;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class IOServiceIndexedTest {
    IOServiceIndexedImpl ioService;
    @Mock
    MetaIndexEngine indexEngine;
    @Mock
    ExecutorService executorService;
    @Mock
    IndexersFactory indexersFactory;
    @Mock
    IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory;
    FileSystemProvider mockProvider;

    @Before
    public void setup() {
        TestFileSystemProvider testProvider = FileSystemProviders.installedProviders().stream().filter(provider -> provider instanceof TestFileSystemProvider).map(provider -> (TestFileSystemProvider)provider).findAny().orElseThrow(() -> new RuntimeException("Failed to setup mock provider for test."));
        testProvider.resetMock();
        this.mockProvider = testProvider.getMock();
        Mockito.when((Object)this.mockProvider.newFileSystem((URI)Matchers.any(URI.class), (Map)Matchers.any())).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.mockProvider.newFileSystem((Path)Matchers.any(Path.class), (Map)Matchers.any())).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.mockProvider.getFileSystem((URI)Matchers.any(URI.class))).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        this.ioService = new IOServiceIndexedImpl(this.indexEngine, this.executorService, this.indexersFactory, this.dispatcherFactory, new Class[0]);
    }

    @Test
    public void recreatingFileSystemMakesNewWatchService() throws Exception {
        URI uri = new URI("test:///some/path");
        Map env = Collections.emptyMap();
        FileSystem fs1 = this.ioService.newFileSystem(uri, env);
        ((FileSystem)Mockito.verify((Object)fs1)).newWatchService();
        FSPath fsPath = (FSPath)Mockito.mock(FSPath.class);
        Mockito.when((Object)fsPath.getFileSystem()).thenReturn((Object)fs1);
        this.ioService.delete((Path)fsPath, new DeleteOption[0]);
        ((WatchService)Mockito.verify((Object)fs1.newWatchService())).close();
        FileSystem fs2 = this.ioService.newFileSystem(uri, env);
        ((FileSystem)Mockito.verify((Object)fs2, (VerificationMode)Mockito.times((int)3))).newWatchService();
    }
}

