/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.ext.metadata.ElasticSearchConfig;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.BatchIndex;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.MetadataConfigBuilder;
import org.uberfire.ext.metadata.io.elasticsearch.BaseIndexTest;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class BatchIndexTest
extends BaseIndexTest {
    @Override
    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new MetadataConfigBuilder("elastic").withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.ioService = new IOServiceDotFileImpl();
        }
        return this.ioService;
    }

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{"elastic-temp-repo-test"};
    }

    @Test
    public void testIndex() throws IOException, InterruptedException {
        Path file = this.ioService().get("git://elastic-temp-repo-test/path/to/file.txt", new String[0]);
        this.ioService().write(file, "some content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My User Name Here";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "initial document version, should be revised later.";
            }
        }});
        file = this.ioService().get("git://elastic-temp-repo-test/path/to/some/complex/file.txt", new String[0]);
        this.ioService().write(file, "some other content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My Second User Name";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "important document, should be used right now.";
            }
        }});
        file = this.ioService().get("git://elastic-temp-repo-test/simple.doc", new String[0]);
        this.ioService().write(file, "some doc content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My Original User";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "unlock document updated, should be checked by boss.";
            }
        }});
        file = this.ioService().get("git://elastic-temp-repo-test/xxx/simple.xls", new String[0]);
        this.ioService().write(file, "plans!?", new OpenOption[0]);
        new BatchIndex(this.config.getIndexEngine(), new Observer(){

            public void information(String message) {
            }

            public void warning(String message) {
            }

            public void error(String message) {
            }
        }, Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory()), this.indexersFactory(), this.indexerDispatcherFactory(this.config.getIndexEngine()), new Class[]{DublinCoreView.class}).run(this.ioService().get("git://elastic-temp-repo-test/", new String[0]).getFileSystem(), () -> {
            try {
                Thread.sleep(2000L);
                KCluster kcluster = KObjectUtil.toKCluster((FileSystem)this.ioService().get("git://elastic-temp-repo-test/", new String[0]).getFileSystem());
                List<String> indices = Arrays.asList(kcluster.getClusterId());
                IndexProvider provider = ((ElasticSearchConfig)this.config).getIndexProvider();
                long hits = provider.findHitsByQuery(indices, (Query)new MatchAllDocsQuery());
                Assert.assertEquals((long)4L, (long)hits);
                hits = provider.findHitsByQuery(indices, (Query)new TermQuery(new Term("dcore.author", "name")));
                Assert.assertEquals((long)2L, (long)hits);
                hits = provider.findHitsByQuery(indices, (Query)new TermQuery(new Term("dcore.author", "second")));
                Assert.assertEquals((long)1L, (long)hits);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail();
            }
        });
    }
}

