/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.BatchIndex;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.MetadataConfigBuilder;
import org.uberfire.ext.metadata.io.lucene.BaseIndexTest;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class BatchIndexTest
extends BaseIndexTest {
    @Override
    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new MetadataConfigBuilder().withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.ioService = new IOServiceDotFileImpl();
        }
        return this.ioService;
    }

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{"temp-repo-test"};
    }

    @Test
    public void testIndex() throws IOException, InterruptedException {
        Path file = this.ioService().get("git://temp-repo-test/path/to/file.txt", new String[0]);
        this.ioService().write(file, "some content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My User Name Here";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "initial document version, should be revised later.";
            }
        }});
        file = this.ioService().get("git://temp-repo-test/path/to/some/complex/file.txt", new String[0]);
        this.ioService().write(file, "some other content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My Second User Name";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "important document, should be used right now.";
            }
        }});
        file = this.ioService().get("git://temp-repo-test/simple.doc", new String[0]);
        this.ioService().write(file, "some doc content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My Original User";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "unlock document updated, should be checked by boss.";
            }
        }});
        file = this.ioService().get("git://temp-repo-test/xxx/simple.xls", new String[0]);
        this.ioService().write(file, "plans!?", new OpenOption[0]);
        new BatchIndex(this.config.getIndexEngine(), new Observer(){

            public void information(String message) {
            }

            public void warning(String message) {
            }

            public void error(String message) {
            }
        }, Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory()), this.indexersFactory(), this.indexerDispatcherFactory(this.config.getIndexEngine()), new Class[]{DublinCoreView.class}).run(this.ioService().get("git://temp-repo-test/", new String[0]).getFileSystem(), () -> {
            try {
                String index = KObjectUtil.toKCluster((FileSystem)this.ioService().get("git://temp-repo-test/", new String[0]).getFileSystem()).getClusterId();
                long hits = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)new MatchAllDocsQuery());
                Assert.assertEquals((long)4L, (long)hits);
                TermQuery query = new TermQuery(new Term("dcore.author", "name"));
                long hits2 = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
                Assert.assertEquals((long)2L, (long)hits2);
                query = new TermQuery(new Term("dcore.author", "second"));
                hits2 = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
                Assert.assertEquals((long)1L, (long)hits2);
                this.config.dispose();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail();
            }
        });
    }
}

