/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.inject.Named;
import org.slf4j.Logger;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.engine.IndexerScheduler;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.event.BatchIndexEvent;
import org.uberfire.ext.metadata.event.IndexEvent;
import org.uberfire.ext.metadata.io.DisposedException;
import org.uberfire.ext.metadata.io.IndexableIOEvent;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class IndexerDispatcher {
    private final Collection<IndexerJob> jobs;
    private final Logger logger;
    private final Event<BatchIndexEvent> batchIndexEvent;
    private final IndexerScheduler.Factory schedulerFactory;

    public static IndexerDispatcherFactory createFactory(MetaIndexEngine indexEngine, IndexerScheduler.Factory schedulerFactory, Event<BatchIndexEvent> batchIndexEvent, Logger logger) {
        return (indexers, cluster) -> new IndexerDispatcher(indexEngine, indexers, cluster, schedulerFactory, batchIndexEvent, logger);
    }

    public IndexerDispatcher(MetaIndexEngine indexEngine, Collection<? extends Indexer> indexers, KCluster cluster, IndexerScheduler.Factory schedulerFactory, Event<BatchIndexEvent> batchIndexEvent, Logger logger) {
        this.schedulerFactory = schedulerFactory;
        this.batchIndexEvent = batchIndexEvent;
        this.logger = logger;
        this.jobs = indexers.stream().map(indexer -> new IndexerJob(indexEngine, (Indexer)indexer, cluster, logger)).collect(Collectors.toList());
    }

    public void offer(IndexableIOEvent event) {
        this.jobs.stream().filter(job -> this.supportsUnderlyingPath(((IndexerJob)job).indexer, event)).forEach(job -> {
            this.logger.debug("Queuing event [{}] for indexer [id={}].", (Object)event, (Object)((IndexerJob)job).indexer.getIndexerId());
            job.offer(event);
        });
    }

    public CompletableFuture<Void> schedule(ExecutorService executor) {
        this.logger.info("Scheduling {} indexing jobs for cluster [{}].", (Object)this.jobs.size(), (Object)this.jobs.stream().findAny().map(job -> ((IndexerJob)job).cluster.toString()).orElse("null"));
        Map jobsById = this.jobs.stream().collect(Collectors.toMap(job -> ((IndexerJob)job).indexer.getIndexerId(), Function.identity()));
        IndexerScheduler scheduler = this.schedulerFactory.create(jobsById);
        CompletableFuture[] allFutures = (CompletableFuture[])scheduler.schedule(executor).map(future -> future.thenAccept(pair -> {
            this.logger.debug("Job finished for indexer [id={}]. Firing batch event.", pair.getK1());
            this.fireBatchIndexEvent((String)pair.getK1(), (List)pair.getK2());
        })).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(allFutures);
    }

    private void fireBatchIndexEvent(String indexerId, List<IndexEvent> events) {
        this.batchIndexEvent.select(new Annotation[]{this.namedQualifierFor(indexerId)}).fire((Object)new BatchIndexEvent(indexerId, events));
    }

    private Named namedQualifierFor(final String indexerId) {
        return new Named(){

            public Class<? extends Annotation> annotationType() {
                return Named.class;
            }

            public String value() {
                return indexerId;
            }
        };
    }

    public void dispose() {
        this.logger.debug("Disposing {} indexing jobs.", (Object)this.jobs.size());
        this.jobs.forEach(job -> job.dispose());
    }

    private boolean supportsUnderlyingPath(Indexer indexer, IndexableIOEvent event) {
        Path path = event.apply(evt -> evt.getFile(), evt -> evt.getNewPath(), evt -> evt.getFile());
        return indexer.supportsPath(path);
    }

    private static class IndexerJob
    implements Supplier<List<IndexEvent>> {
        private final Indexer indexer;
        private final Deque<IndexableIOEvent> inputEvents = new ArrayDeque<IndexableIOEvent>();
        private final MetaIndexEngine indexEngine;
        private final AtomicBoolean disposed = new AtomicBoolean(false);
        private final Logger logger;
        private final KCluster cluster;

        IndexerJob(MetaIndexEngine indexEngine, Indexer indexer, KCluster cluster, Logger logger) {
            this.indexEngine = indexEngine;
            this.indexer = indexer;
            this.cluster = cluster;
            this.logger = logger;
        }

        void offer(IndexableIOEvent event) {
            this.inputEvents.add(event);
        }

        void dispose() {
            this.logger.debug("Disposing job for indexer [id={}].", (Object)this.indexer.getIndexerId());
            this.disposed.set(true);
        }

        @Override
        public List<IndexEvent> get() {
            this.logger.debug("Starting to process events for indexer [id={}].", (Object)this.indexer.getIndexerId());
            this.indexEngine.startBatch(this.cluster);
            try {
                List<IndexEvent> output = this.processEvents();
                this.indexEngine.commit(this.cluster, this.indexer.getIndexerId());
                this.logger.info("Completed indexing {} events for indexer [id={}] in cluster [{}].", new Object[]{output.size(), this.indexer.getIndexerId(), this.cluster});
                return output;
            }
            catch (DisposedException de) {
                this.logger.info("Indexing for indexer [id={}] was terminated before completion.", (Object)this.indexer.getIndexerId());
                this.indexEngine.abort(this.cluster);
                throw de;
            }
            catch (Throwable t) {
                this.logger.error(String.format("Indexing error for indexer [id=%s]", this.indexer.getIndexerId()), t);
                this.indexEngine.abort(this.cluster);
                throw t;
            }
        }

        private List<IndexEvent> processEvents() {
            ArrayList<IndexEvent> outputEvents = new ArrayList<IndexEvent>(this.inputEvents.size());
            while (!this.inputEvents.isEmpty()) {
                IndexableIOEvent event = this.inputEvents.poll();
                if (this.disposed.get()) {
                    throw new DisposedException();
                }
                if (IndexerJob.isFileSystemOpen(event)) {
                    this.processEvent(event).ifPresent(outputEvents::add);
                    continue;
                }
                this.logger.debug("Skipping indexing of [{}] for indexer [id={}], because the filesystem [{}] is closed.", new Object[]{event, this.indexer.getIndexerId(), IndexerJob.fileSystemOf(event)});
            }
            return outputEvents;
        }

        private static boolean isFileSystemOpen(IndexableIOEvent event) {
            return IndexerJob.fileSystemOf(event).isOpen();
        }

        private static FileSystem fileSystemOf(IndexableIOEvent event) {
            return event.apply(evt -> evt.getFile().getFileSystem(), evt -> evt.getNewPath().getFileSystem(), evt -> evt.getFile().getFileSystem());
        }

        private Optional<IndexEvent> processEvent(IndexableIOEvent event) {
            this.logger.debug("Processing event [{}] for indexer [id={}].", (Object)event, (Object)this.indexer.getIndexerId());
            return event.apply(this::processNew, this::processRenamed, this::processDeleted);
        }

        private Optional<IndexEvent> processRenamed(IndexableIOEvent.RenamedFileEvent event) {
            Path sourcePath = event.getOldPath();
            Path destinationPath = event.getNewPath();
            KObjectKey kObjectSource = this.indexer.toKObjectKey(sourcePath);
            KObject kObjectDestination = this.indexer.toKObject(destinationPath);
            if (kObjectSource != null && kObjectDestination != null) {
                this.indexEngine.rename(kObjectSource, kObjectDestination);
                return Optional.of(new IndexEvent.RenamedEvent(kObjectSource, kObjectDestination));
            }
            return Optional.empty();
        }

        private Optional<IndexEvent> processNew(IndexableIOEvent.NewFileEvent event) {
            Path path = event.getFile();
            KObject kObject = this.indexer.toKObject(path);
            if (kObject != null) {
                this.indexEngine.index(kObject);
                return Optional.of(new IndexEvent.NewlyIndexedEvent(kObject));
            }
            return Optional.empty();
        }

        private Optional<IndexEvent> processDeleted(IndexableIOEvent.DeletedFileEvent event) {
            Path oldPath = event.getFile();
            KObjectKey kObject = this.indexer.toKObjectKey(oldPath);
            if (kObject != null) {
                this.indexEngine.delete(kObject);
                return Optional.of(new IndexEvent.DeletedEvent(kObject));
            }
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface IndexerDispatcherFactory {
        public IndexerDispatcher create(Collection<? extends Indexer> var1, KCluster var2);
    }
}

