/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.event.IndexEvent;
import org.uberfire.ext.metadata.io.util.MultiIndexerLock;
import org.uberfire.ext.metadata.metamodel.MetaModelBuilder;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.provider.IndexProvider;

public class MetadataIndexEngine
implements MetaIndexEngine {
    private final MetaModelBuilder metaModelBuilder;
    private final Logger logger = LoggerFactory.getLogger(MetadataIndexEngine.class);
    private final IndexProvider provider;
    private final Map<KCluster, MultiIndexerLock> batchLocks = new ConcurrentHashMap<KCluster, MultiIndexerLock>();
    private final ThreadLocal<Map<KCluster, List<IndexEvent>>> batchSets = ThreadLocal.withInitial(() -> new HashMap());
    private final Collection<Runnable> beforeDispose = new ArrayList<Runnable>();
    private final Supplier<MultiIndexerLock> lockSupplier;

    public MetadataIndexEngine(IndexProvider provider, MetaModelStore metaModelStore, Supplier<MultiIndexerLock> lockSupplier) {
        this.provider = provider;
        this.metaModelBuilder = new MetaModelBuilder(metaModelStore);
        this.lockSupplier = lockSupplier;
        PriorityDisposableRegistry.register((PriorityDisposable)this);
    }

    public MetadataIndexEngine(IndexProvider provider, MetaModelStore metaModelStore) {
        this(provider, metaModelStore, () -> new MultiIndexerLock(new ReentrantLock()));
    }

    public boolean freshIndex(KCluster cluster) {
        boolean isFreshIndex;
        boolean bl = isFreshIndex = this.provider.isFreshIndex(cluster) && !this.batchLocks.containsKey(cluster);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Is fresh index? " + isFreshIndex);
        }
        return isFreshIndex;
    }

    public boolean isIndexReady(KCluster cluster, String indexerId) {
        MultiIndexerLock lock;
        return !this.provider.isFreshIndex(cluster) && ((lock = this.batchLocks.get(cluster)) == null || !lock.isLockedBy(indexerId));
    }

    public void prepareBatch(KCluster cluster) {
        this.batchLocks.computeIfAbsent(cluster, ignore -> this.lockSupplier.get());
    }

    public void startBatch(KCluster cluster) {
        this.prepareBatch(cluster);
        Map<KCluster, List<IndexEvent>> batchSet = this.batchSets.get();
        if (batchSet.containsKey(cluster)) {
            throw new IllegalStateException(String.format("Cannot start a batch for cluster [id=%s] when there is already a batch started on this thread [%s]", cluster.getClusterId(), Thread.currentThread().getName()));
        }
        batchSet.put(cluster, new ArrayList());
    }

    private void doOrDeferAction(KCluster index, IndexEvent event) {
        if (this.isBatch(index)) {
            List<IndexEvent> store = this.batchSets.get().get(index);
            store.add(event);
        } else {
            this.doAction(event);
        }
    }

    public void index(KObject kObject) {
        KClusterImpl index = new KClusterImpl(kObject.getClusterId());
        this.doOrDeferAction((KCluster)index, (IndexEvent)new IndexEvent.NewlyIndexedEvent(kObject));
    }

    private void doAction(IndexEvent event) {
        switch (event.getKind()) {
            case NewlyIndexed: {
                IndexEvent.NewlyIndexedEvent newlyIndexedEvent = (IndexEvent.NewlyIndexedEvent)event;
                this.doIndex(newlyIndexedEvent.getKObject());
                break;
            }
            case Renamed: {
                IndexEvent.RenamedEvent renamedEvent = (IndexEvent.RenamedEvent)event;
                this.doRename(renamedEvent.getSource(), renamedEvent.getTarget());
                break;
            }
            case Deleted: {
                IndexEvent.DeletedEvent deletedEvent = (IndexEvent.DeletedEvent)event;
                this.doDelete(deletedEvent.getDeleted());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized index event kind: " + event.getKind());
            }
        }
    }

    private void doIndex(KObject kObject) {
        this.metaModelBuilder.updateMetaModel(kObject);
        this.provider.index(kObject);
    }

    private boolean isBatch(KCluster cluster) {
        Map<KCluster, List<IndexEvent>> batchSet = this.batchSets.get();
        if (batchSet.isEmpty()) {
            this.batchSets.remove();
        }
        return batchSet.containsKey(cluster);
    }

    public void rename(KObjectKey from, KObject to) {
        PortablePreconditions.checkNotNull((String)"from", (Object)from);
        PortablePreconditions.checkNotNull((String)"to", (Object)to);
        PortablePreconditions.checkCondition((String)"renames are allowed only from same cluster", (boolean)from.getClusterId().equals(to.getClusterId()));
        KClusterImpl index = new KClusterImpl(from.getClusterId());
        this.doOrDeferAction((KCluster)index, (IndexEvent)new IndexEvent.RenamedEvent(from, to));
    }

    private void doRename(KObjectKey from, KObject to) {
        this.provider.rename(from.getClusterId(), from.getId(), to);
    }

    protected boolean exists(KObjectKey from) {
        return this.provider.exists(from.getClusterId(), from.getId());
    }

    public void delete(KCluster cluster) {
        this.batchLocks.remove(cluster);
        this.provider.delete(cluster.getClusterId());
    }

    public void delete(KObjectKey objectKey) {
        KClusterImpl index = new KClusterImpl(objectKey.getClusterId());
        this.doOrDeferAction((KCluster)index, (IndexEvent)new IndexEvent.DeletedEvent(objectKey));
    }

    private void doDelete(KObjectKey objectKey) {
        this.provider.delete(objectKey.getClusterId(), objectKey.getId());
    }

    public void commit(KCluster cluster, String indexerId) {
        boolean clusterDeleted;
        MultiIndexerLock lock = this.batchLocks.get(cluster);
        List<IndexEvent> batchSet = this.batchSets.get().get(cluster);
        boolean bl = clusterDeleted = lock == null && batchSet != null;
        if (clusterDeleted) {
            this.logger.info("Cluster [{}] was deleted. Aborting commit for indexer [{}].", (Object)cluster.getClusterId(), (Object)indexerId);
            this.abort(cluster);
            return;
        }
        try {
            if (batchSet == null) {
                throw new IllegalStateException(String.format("Cannot commit batch for cluster [id=%s] when no batch has been started in thread [%s].", cluster.getClusterId(), Thread.currentThread().getName()));
            }
            if (batchSet.isEmpty()) {
                this.removeThreadLocalBatchState(cluster);
            } else {
                this.doCommit(cluster, batchSet, lock, indexerId);
            }
        }
        catch (Throwable t) {
            this.abort(cluster);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(KCluster cluster, List<IndexEvent> batchSet, MultiIndexerLock lock, String indexerId) {
        try {
            lock.lock(indexerId);
            batchSet.forEach(this::doAction);
            this.removeThreadLocalBatchState(cluster);
        }
        finally {
            lock.unlock(indexerId);
        }
    }

    public void abort(KCluster cluster) {
        this.removeThreadLocalBatchState(cluster);
    }

    private void removeThreadLocalBatchState(KCluster cluster) {
        Map<KCluster, List<IndexEvent>> batchSet = this.batchSets.get();
        batchSet.remove(cluster);
        if (batchSet.isEmpty()) {
            this.batchSets.remove();
        }
    }

    public void beforeDispose(Runnable callback) {
        this.beforeDispose.add((Runnable)PortablePreconditions.checkNotNull((String)"callback", (Object)callback));
    }

    public int priority() {
        return 50;
    }

    public void dispose() {
        if (!this.beforeDispose.isEmpty()) {
            for (Runnable activeDispose : this.beforeDispose) {
                activeDispose.run();
            }
        }
    }
}

