/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.WildcardQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="infinispan.btm")
public class IOServiceIndexedSortingTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getSimpleName()};
    }

    @Test
    public void testSortedFiles() {
        Path base = this.writeFile("cFile1.txt");
        this.writeFile("CFile2.txt");
        this.writeFile("bFile.txt");
        this.writeFile("aFile.txt");
        List<String> indices = Arrays.asList(AttributesUtil.toProtobufFormat((String)KObjectUtil.toKCluster((Path)base).getClusterId()));
        IndexProvider provider = this.config.getIndexProvider();
        Sort sort = new Sort(new SortField("filenamesorted", SortField.Type.STRING));
        WildcardQuery query = new WildcardQuery(new Term("filename", "*txt"));
        List documents = provider.findByQuery(indices, (Query)query, sort, 10);
        Assert.assertEquals((long)4L, (long)documents.size());
        Assert.assertEquals((Object)"aFile.txt", (Object)this.getProperty((KObject)documents.get(0), "filename").getValue());
        Assert.assertEquals((Object)"bFile.txt", (Object)this.getProperty((KObject)documents.get(1), "filename").getValue());
        Assert.assertEquals((Object)"cFile1.txt", (Object)this.getProperty((KObject)documents.get(2), "filename").getValue());
        Assert.assertEquals((Object)"CFile2.txt", (Object)this.getProperty((KObject)documents.get(3), "filename").getValue());
    }

    private KProperty<?> getProperty(KObject document, String name) {
        return StreamSupport.stream(document.getProperties().spliterator(), false).filter(kProperty -> kProperty.getName().equals(name)).findAny().get();
    }

    private Path writeFile(String fileName) {
        this.setupCountDown(1);
        Path path = this.getBasePath(this.getSimpleName()).resolve(fileName);
        this.ioService().write(path, "content", Collections.emptySet(), new FileAttribute[0]);
        this.waitForCountDown(1000);
        return path;
    }
}

