/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.io.IndexableIOEvent;
import org.uberfire.ext.metadata.io.IndexerDispatcher;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.common.util.TestFileSystemProvider;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.java.nio.base.AttrsStorage;
import org.uberfire.java.nio.base.FSPath;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class IOServiceIndexedTest {
    IOServiceIndexedImpl ioService;
    @Mock
    MetaIndexEngine indexEngine;
    @Mock
    ExecutorService executorService;
    @Mock
    IndexersFactory indexersFactory;
    @Mock
    IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory;
    FileSystemProvider mockProvider;

    @Before
    public void setup() throws URISyntaxException {
        TestFileSystemProvider testProvider = FileSystemProviders.installedProviders().stream().filter(provider -> provider instanceof TestFileSystemProvider).map(provider -> (TestFileSystemProvider)provider).findAny().orElseThrow(() -> new RuntimeException("Failed to setup mock provider for test."));
        testProvider.resetMock();
        this.mockProvider = testProvider.getMock();
        Mockito.when((Object)this.mockProvider.newFileSystem((URI)Matchers.any(URI.class), (Map)Matchers.any())).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.mockProvider.newFileSystem((Path)Matchers.any(Path.class), (Map)Matchers.any())).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.mockProvider.getFileSystem((URI)Matchers.any(URI.class))).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        this.ioService = (IOServiceIndexedImpl)Mockito.spy((Object)new IOServiceIndexedImpl(this.indexEngine, this.executorService, this.indexersFactory, this.dispatcherFactory, new Class[0]));
    }

    @Test
    public void recreatingFileSystemMakesNewWatchService() throws Exception {
        URI uri = new URI("test:///some/path");
        Map env = Collections.emptyMap();
        FileSystem fs1 = this.ioService.newFileSystem(uri, env);
        ((FileSystem)Mockito.verify((Object)fs1)).newWatchService();
        FSPath fsPath = (FSPath)Mockito.mock(FSPath.class);
        Mockito.when((Object)fsPath.getFileSystem()).thenReturn((Object)fs1);
        this.ioService.delete((Path)fsPath, new DeleteOption[0]);
        ((WatchService)Mockito.verify((Object)fs1.newWatchService())).close();
        FileSystem fs2 = this.ioService.newFileSystem(uri, env);
        ((FileSystem)Mockito.verify((Object)fs2, (VerificationMode)Mockito.times((int)3))).newWatchService();
    }

    @Test
    public void deleteFSTest() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        FSPath fsPath = (FSPath)Mockito.mock(FSPath.class);
        Mockito.when((Object)fsPath.getFileSystem()).thenReturn((Object)fileSystem);
        this.ioService.delete((Path)fsPath, new DeleteOption[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ioService, this.indexEngine, fileSystem});
        ((MetaIndexEngine)inOrder.verify((Object)this.indexEngine)).delete((KCluster)Matchers.any(KCluster.class));
        ((IOServiceIndexedImpl)inOrder.verify((Object)this.ioService)).deleteRepositoryFiles((Path)Matchers.eq((Object)fsPath), (DeleteOption[])Matchers.any());
    }

    @Test
    public void deleteBranchTest() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        Path branchPath = (Path)fileSystem.getRootDirectories().iterator().next();
        this.ioService.delete(branchPath, new DeleteOption[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ioService, this.indexEngine, fileSystem});
        ((MetaIndexEngine)inOrder.verify((Object)this.indexEngine)).delete((KCluster)Matchers.any(KCluster.class));
        ((IOServiceIndexedImpl)inOrder.verify((Object)this.ioService)).deleteRepositoryFiles((Path)Matchers.eq((Object)branchPath), (DeleteOption[])Matchers.any());
    }

    @Test
    public void deleteFileTest() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        Path file = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)file.getFileSystem()).thenReturn((Object)fileSystem);
        this.ioService.delete(file, new DeleteOption[0]);
        ((MetaIndexEngine)Mockito.verify((Object)this.indexEngine, (VerificationMode)Mockito.never())).delete((KCluster)Matchers.any(KCluster.class));
        ((IOServiceIndexedImpl)Mockito.verify((Object)this.ioService)).deleteRepositoryFiles((Path)Matchers.eq((Object)file), (DeleteOption[])Matchers.any());
    }

    @Test
    public void dotFileShouldBeIgnored() {
        Path path = (Path)Mockito.mock(Path.class);
        Path fileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)path.getFileName().toString()).thenReturn((Object)".sample.drl");
        Assert.assertTrue((boolean)this.ioService.isIgnored(path));
    }

    @Test
    public void queueRenameShouldDispatchIndexEventTest() throws Exception {
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        IndexerDispatcher dispatcher = (IndexerDispatcher)Mockito.mock(IndexerDispatcher.class);
        Path oldPath = (Path)Mockito.mock(Path.class);
        Path newPath = (Path)Mockito.mock(Path.class);
        Path fileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)newPath.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)newPath.getFileName().toString()).thenReturn((Object)"sample.drl");
        Mockito.when((Object)context.getOldPath()).thenReturn((Object)oldPath);
        Mockito.when((Object)context.getPath()).thenReturn((Object)newPath);
        this.ioService.queueRenameEvent(context, dispatcher);
        ((IndexerDispatcher)Mockito.verify((Object)dispatcher, (VerificationMode)Mockito.times((int)1))).offer((IndexableIOEvent)Matchers.refEq((Object)new IndexableIOEvent.RenamedFileEvent(oldPath, newPath), (String[])new String[0]));
    }

    @Test
    public void queueRenameShouldNotDispatchIndexEventTest() throws Exception {
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        IndexerDispatcher dispatcher = (IndexerDispatcher)Mockito.mock(IndexerDispatcher.class);
        Path oldPath = (Path)Mockito.mock(Path.class);
        Path newPath = (Path)Mockito.mock(Path.class);
        Path fileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)newPath.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)newPath.getFileName().toString()).thenReturn((Object)".sample.drl");
        Mockito.when((Object)context.getOldPath()).thenReturn((Object)oldPath);
        Mockito.when((Object)context.getPath()).thenReturn((Object)newPath);
        this.ioService.queueRenameEvent(context, dispatcher);
        ((IndexerDispatcher)Mockito.verify((Object)dispatcher, (VerificationMode)Mockito.times((int)0))).offer((IndexableIOEvent)Matchers.refEq((Object)new IndexableIOEvent.RenamedFileEvent(oldPath, newPath), (String[])new String[0]));
    }

    @Test
    public void queueDeleteShouldDispatchIndexEventTest() throws Exception {
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        IndexerDispatcher dispatcher = (IndexerDispatcher)Mockito.mock(IndexerDispatcher.class);
        Path oldPath = (Path)Mockito.mock(Path.class);
        Path fileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)oldPath.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)oldPath.getFileName().toString()).thenReturn((Object)"sample.drl");
        Mockito.when((Object)context.getOldPath()).thenReturn((Object)oldPath);
        this.ioService.queueDeleteEvent(context, dispatcher);
        ((IndexerDispatcher)Mockito.verify((Object)dispatcher, (VerificationMode)Mockito.times((int)1))).offer((IndexableIOEvent)Matchers.refEq((Object)new IndexableIOEvent.DeletedFileEvent(oldPath), (String[])new String[0]));
    }

    @Test
    public void queueDeleteShouldNotDispatchIndexEventTest() throws Exception {
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        IndexerDispatcher dispatcher = (IndexerDispatcher)Mockito.mock(IndexerDispatcher.class);
        Path oldPath = (Path)Mockito.mock(Path.class);
        Path fileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)oldPath.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)oldPath.getFileName().toString()).thenReturn((Object)".sample.drl");
        Mockito.when((Object)context.getOldPath()).thenReturn((Object)oldPath);
        this.ioService.queueDeleteEvent(context, dispatcher);
        ((IndexerDispatcher)Mockito.verify((Object)dispatcher, (VerificationMode)Mockito.times((int)0))).offer((IndexableIOEvent)Matchers.refEq((Object)new IndexableIOEvent.DeletedFileEvent(oldPath), (String[])new String[0]));
    }

    @Test
    public void queueCreationAndModificationEventShouldUndotAndDispatchTest() throws Exception {
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        IndexerDispatcher dispatcher = (IndexerDispatcher)Mockito.mock(IndexerDispatcher.class);
        Path path = (Path)Mockito.mock(Path.class);
        Path fileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)path.getFileName().toString()).thenReturn((Object)".sample.drl");
        Mockito.when((Object)context.getPath()).thenReturn((Object)path);
        Path realPath = (Path)Mockito.mock(Path.class);
        Path realFileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)realPath.getFileName()).thenReturn((Object)realFileName);
        Mockito.when((Object)realPath.getFileName().toString()).thenReturn((Object)"sample.drl");
        HashSet eventRealPaths = new HashSet();
        Mockito.when((Object)path.resolveSibling("sample.drl")).thenReturn((Object)realPath);
        this.ioService.queueCreationAndModificationEvent(eventRealPaths, context, dispatcher);
        ((IndexerDispatcher)Mockito.verify((Object)dispatcher, (VerificationMode)Mockito.times((int)1))).offer((IndexableIOEvent)Matchers.refEq((Object)new IndexableIOEvent.NewFileEvent(realPath), (String[])new String[0]));
    }

    @Test
    public void shouldNotAddBlankFilesToEventRealPathsTest() throws Exception {
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        IndexerDispatcher dispatcher = (IndexerDispatcher)Mockito.mock(IndexerDispatcher.class);
        Mockito.when((Object)context.getPath()).thenReturn(null);
        WatchEvent watchEvent = (WatchEvent)Mockito.mock(WatchEvent.class);
        Mockito.when((Object)watchEvent.context()).thenReturn((Object)context);
        Mockito.when((Object)watchEvent.kind()).thenReturn((Object)StandardWatchEventKind.ENTRY_MODIFY);
        List<WatchEvent> watchEvents = Arrays.asList(watchEvent);
        Set eventRealPaths = this.ioService.getRealCreatedPaths(watchEvents);
        Assert.assertEquals((long)0L, (long)eventRealPaths.size());
    }

    @Test
    public void shouldNotAddDotFilesToEventRealPathsTest() throws Exception {
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        IndexerDispatcher dispatcher = (IndexerDispatcher)Mockito.mock(IndexerDispatcher.class);
        Path path = (Path)Mockito.mock(Path.class);
        Path fileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)path.getFileName().toString()).thenReturn((Object)".sample.drl");
        Mockito.when((Object)context.getPath()).thenReturn((Object)path);
        WatchEvent watchEvent = (WatchEvent)Mockito.mock(WatchEvent.class);
        Mockito.when((Object)watchEvent.context()).thenReturn((Object)context);
        Mockito.when((Object)watchEvent.kind()).thenReturn((Object)StandardWatchEventKind.ENTRY_MODIFY);
        List<WatchEvent> watchEvents = Arrays.asList(watchEvent);
        Set eventRealPaths = this.ioService.getRealCreatedPaths(watchEvents);
        Assert.assertEquals((long)0L, (long)eventRealPaths.size());
    }

    @Test
    public void shouldAddRealFilesToEventRealPathsTest() throws Exception {
        WatchContext context = (WatchContext)Mockito.mock(WatchContext.class);
        IndexerDispatcher dispatcher = (IndexerDispatcher)Mockito.mock(IndexerDispatcher.class);
        Path path = (Path)Mockito.mock(Path.class);
        Path fileName = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)path.getFileName().toString()).thenReturn((Object)"sample.drl");
        Mockito.when((Object)context.getPath()).thenReturn((Object)path);
        WatchEvent watchEvent = (WatchEvent)Mockito.mock(WatchEvent.class);
        Mockito.when((Object)watchEvent.context()).thenReturn((Object)context);
        Mockito.when((Object)watchEvent.kind()).thenReturn((Object)StandardWatchEventKind.ENTRY_MODIFY);
        List<WatchEvent> watchEvents = Arrays.asList(watchEvent);
        Set eventRealPaths = this.ioService.getRealCreatedPaths(watchEvents);
        Assert.assertEquals((long)1L, (long)eventRealPaths.size());
    }

    private FileSystem getFileSystem() throws URISyntaxException {
        URI uri = new URI("test:///some/path");
        Map env = Collections.emptyMap();
        FileSystem fileSystem = this.ioService.newFileSystem(uri, env);
        Path fsRootDirectory1 = (Path)Mockito.mock(JGitPathImpl.class);
        Mockito.when((Object)fsRootDirectory1.getFileSystem()).thenReturn((Object)fileSystem);
        Mockito.when((Object)fsRootDirectory1.getRoot()).thenReturn((Object)fsRootDirectory1);
        Mockito.when((Object)((JGitPathImpl)fsRootDirectory1).getAttrStorage()).thenReturn(Mockito.mock(AttrsStorage.class));
        Path fsRootDirectory2 = (Path)Mockito.mock(JGitPathImpl.class);
        Mockito.when((Object)fsRootDirectory2.getFileSystem()).thenReturn((Object)fileSystem);
        Mockito.when((Object)fsRootDirectory2.getRoot()).thenReturn((Object)fsRootDirectory2);
        Mockito.when((Object)((JGitPathImpl)fsRootDirectory2).getAttrStorage()).thenReturn(Mockito.mock(AttrsStorage.class));
        List<Path> fsRootDirectories = Arrays.asList(fsRootDirectory1, fsRootDirectory2);
        ((FileSystem)Mockito.doReturn(fsRootDirectories).when((Object)fileSystem)).getRootDirectories();
        return fileSystem;
    }
}

