/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.metadata.io.util.MultiIndexerLock;

public class MultiIndexerLockTest {
    MultiIndexerLock multiIndexerLock;
    TestThreadWrapper<Boolean> writer1;
    TestThreadWrapper<Boolean> writer2;
    TestThreadWrapper<Boolean> reader1;
    TestThreadWrapper<Boolean> reader2;
    ReentrantLock underlyingLock;

    @Before
    public void setup() {
        this.underlyingLock = new ReentrantLock();
        this.multiIndexerLock = new MultiIndexerLock(this.underlyingLock);
        this.writer1 = new TestThreadWrapper<Boolean>(() -> {
            this.multiIndexerLock.lock("1");
            return true;
        }, "writer1");
        this.writer2 = new TestThreadWrapper<Boolean>(() -> {
            this.multiIndexerLock.lock("2");
            return true;
        }, "writer2");
        this.reader1 = new TestThreadWrapper<Boolean>(() -> this.multiIndexerLock.isLockedBy("1"), "reader1");
        this.reader2 = new TestThreadWrapper<Boolean>(() -> this.multiIndexerLock.isLockedBy("2"), "reader2");
    }

    @After
    public void cleanup() {
        this.writer1.stop();
        this.writer2.stop();
        this.reader1.stop();
        this.reader2.stop();
    }

    @Test
    public void acquiringUncontestedLock() throws Exception {
        CompletableFuture<Boolean> writer1Result = this.writer1.start();
        this.assertCompletedNormally(1L, TimeUnit.SECONDS, writer1Result);
    }

    @Test
    public void cannotAcquireOwnedLock() throws Exception {
        CompletableFuture<Boolean> first = this.writer1.start();
        CompletionStage second = first.thenCompose(ignore -> this.writer2.start());
        this.assertCompletedNormally(1L, TimeUnit.SECONDS, first);
        this.assertIncomplete(1L, TimeUnit.SECONDS, new CompletableFuture[]{second});
    }

    @Test
    public void readingReturnsCorrectResultWhileUnlocked() throws Exception {
        CompletableFuture<Boolean> reader1Result = this.reader1.start();
        CompletableFuture<Boolean> reader2Result = this.reader2.start();
        this.assertCompletedNormally(1L, TimeUnit.SECONDS, reader1Result, reader2Result);
        Assert.assertFalse((boolean)reader1Result.get());
        Assert.assertFalse((boolean)reader2Result.get());
    }

    @Test
    public void readingReturnsCorrectResultWhileLocked() throws Exception {
        CompletableFuture<Boolean> lockAcquired = this.writer1.start();
        this.assertCompletedNormally(1L, TimeUnit.SECONDS, lockAcquired);
        CompletableFuture<Boolean> reader1Result = this.reader1.start();
        CompletableFuture<Boolean> reader2Result = this.reader2.start();
        this.assertCompletedNormally(1L, TimeUnit.SECONDS, reader1Result, reader2Result);
        Assert.assertTrue((boolean)reader1Result.get());
        Assert.assertFalse((boolean)reader2Result.get());
    }

    @Test
    public void writingNotifiesSingleWaitingRead() throws Exception {
        this.underlyingLock.lock();
        this.writer1.start();
        CompletableFuture<Boolean> readerResult = this.reader1.start();
        this.assertIncomplete(1L, TimeUnit.SECONDS, readerResult);
        this.underlyingLock.unlock();
        this.assertCompletedNormally(1L, TimeUnit.SECONDS, readerResult);
        Assert.assertTrue((boolean)readerResult.get());
    }

    @Test
    public void writingNotifiesMultipleWaitingReads() throws Exception {
        this.underlyingLock.lock();
        this.writer1.start();
        CompletableFuture<Boolean> reader1Result = this.reader1.start();
        CompletableFuture<Boolean> reader2Result = this.reader2.start();
        this.assertIncomplete(1L, TimeUnit.SECONDS, reader1Result, reader2Result);
        this.underlyingLock.unlock();
        this.assertCompletedNormally(1L, TimeUnit.SECONDS, reader1Result, reader2Result);
        Assert.assertTrue((boolean)reader1Result.get());
        Assert.assertFalse((boolean)reader2Result.get());
    }

    private void assertCompletedNormally(long duration, TimeUnit unit, CompletableFuture<?> ... futures) {
        try {
            CompletableFuture.allOf(futures).get(duration, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new AssertionError("Future did not complete normally.", e);
        }
    }

    private void assertIncomplete(long duration, TimeUnit unit, CompletableFuture<?> ... futures) {
        try {
            CompletableFuture.allOf(futures).get(duration, unit);
            throw new AssertionError((Object)"Futures completed normally.");
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError("Future completed exceptionally.", e);
        }
        catch (TimeoutException timeoutException) {
            return;
        }
    }

    private static class TestThreadWrapper<T> {
        final Thread thread;
        final CompletableFuture<T> future = new CompletableFuture();

        TestThreadWrapper(Supplier<T> action, String name) {
            this.thread = new Thread(() -> {
                try {
                    Object t = action.get();
                    this.future.complete(t);
                }
                catch (Throwable t) {
                    this.future.completeExceptionally(t);
                }
            }, name);
        }

        CompletableFuture<T> start() {
            this.thread.start();
            return this.future;
        }

        void stop() {
            try {
                this.thread.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

