/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.MetadataConfigBuilder;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.model.schema.MetaType;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="infinispan.btm")
public class FullTextSearchIndexTest
extends BaseIndexTest {
    @Override
    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new MetadataConfigBuilder("infinispan").withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.ioService = new IOServiceIndexedImpl(this.config.getIndexEngine(), Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory()), this.indexersFactory(), this.indexerDispatcherFactory(this.config.getIndexEngine()), new Class[]{DublinCoreView.class, VersionAttributeView.class});
            this.indexersFactory().addIndexer((Indexer)new MockIndexer());
        }
        return this.ioService;
    }

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{"indexable_" + this.getClass().getSimpleName()};
    }

    @Test
    public void testFullTextIndexedFile() throws IOException, InterruptedException {
        this.setupCountDown(2);
        Path path1 = this.getBasePath("indexable_" + this.getClass().getSimpleName()).resolve("mydrlfile1.drl");
        this.ioService().write(path1, "Some cheese", new OpenOption[0]);
        this.waitForCountDown(10000);
        List<String> indices = Arrays.asList(AttributesUtil.toProtobufFormat((String)KObjectUtil.toKCluster((Path)path1).getClusterId()));
        IndexProvider provider = this.config.getIndexProvider();
        WildcardQuery query = new WildcardQuery(new Term("fullText", "*file*"));
        long hits = provider.findHitsByQuery(indices, (Query)query);
        Assert.assertEquals((long)1L, (long)hits);
        query = new WildcardQuery(new Term("fullText", "*mydrlfile1*"));
        hits = provider.findHitsByQuery(indices, (Query)query);
        Assert.assertEquals((long)1L, (long)hits);
        this.setupCountDown(2);
        Path path2 = this.getBasePath("indexable_" + this.getClass().getSimpleName()).resolve("a.drl");
        this.ioService().write(path2, "Some cheese", new OpenOption[0]);
        this.waitForCountDown(10000);
        WildcardQuery query2 = new WildcardQuery(new Term("fullText", "a.d*"));
        long hits2 = provider.findHitsByQuery(indices, (Query)query2);
        Assert.assertEquals((long)1L, (long)hits2);
    }

    private static class TestKObjectWrapper
    extends TestKObjectKeyWrapper
    implements KObject {
        private TestKObjectWrapper(KObject delegate) {
            super((KObjectKey)delegate);
        }

        public Iterable<KProperty<?>> getProperties() {
            return ((KObject)this.delegate).getProperties();
        }

        public boolean fullText() {
            return false;
        }
    }

    private static class TestKObjectKeyWrapper
    implements KObjectKey {
        protected KObjectKey delegate;

        private TestKObjectKeyWrapper(KObjectKey delegate) {
            this.delegate = delegate;
        }

        public String getId() {
            return this.delegate.getId() + "-refactoring";
        }

        public MetaType getType() {
            return this.delegate.getType();
        }

        public String getClusterId() {
            return this.delegate.getClusterId();
        }

        public String getSegmentId() {
            return this.delegate.getSegmentId();
        }

        public String getKey() {
            return this.delegate.getKey();
        }
    }

    private static class MockIndexer
    implements Indexer {
        private MockIndexer() {
        }

        public boolean supportsPath(Path path) {
            return true;
        }

        public KObject toKObject(Path path) {
            return new TestKObjectWrapper(KObjectUtil.toKObject((Path)path, (FileAttribute[])new FileAttribute[0]));
        }

        public KObjectKey toKObjectKey(Path path) {
            return new TestKObjectKeyWrapper(KObjectUtil.toKObjectKey((Path)path));
        }
    }
}

