/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.common;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.io.index.MetadataIndexEngine;
import org.uberfire.ext.metadata.io.util.MultiIndexerLock;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.model.impl.KObjectImpl;
import org.uberfire.ext.metadata.model.impl.KObjectKeyImpl;
import org.uberfire.ext.metadata.provider.IndexProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataIndexEngineBatchTest {
    private static final String TEST_INDEXER = "test-indexer";
    private MetadataIndexEngine indexEngine;
    @Mock
    private IndexProvider provider;
    @Mock
    private MetaModelStore metaModelStore;
    @Mock
    private MultiIndexerLock lock;
    private KCluster cluster;
    private KObject kObject;
    private KObjectKey kObjectKey;

    @Before
    public void setup() {
        this.cluster = new KClusterImpl("test-cluster");
        this.kObject = new KObjectImpl("1", "java", this.cluster.getClusterId(), "segment", "key", Collections.emptyList(), true);
        this.kObjectKey = new KObjectKeyImpl("key", "2", "java", this.cluster.getClusterId(), "segment");
        this.indexEngine = new MetadataIndexEngine(this.provider, this.metaModelStore, () -> this.lock);
    }

    @Test
    public void indexDeferredInBatchMode() throws Exception {
        this.indexEngine.startBatch(this.cluster);
        this.indexEngine.index(this.kObject);
        ((IndexProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).index((KObject)Matchers.same((Object)this.kObject));
    }

    @Test
    public void indexCalledWhenBatchCommitted() throws Exception {
        this.indexDeferredInBatchMode();
        this.indexEngine.commit(this.cluster, TEST_INDEXER);
        ((IndexProvider)Mockito.verify((Object)this.provider)).index((KObject)Matchers.same((Object)this.kObject));
    }

    @Test
    public void indexNeverCalledWhenBatchAborted() throws Exception {
        this.indexDeferredInBatchMode();
        this.indexEngine.abort(this.cluster);
        ((IndexProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).index((KObject)Matchers.any(KObject.class));
    }

    @Test
    public void renameDeferredInBatchMode() throws Exception {
        this.indexEngine.startBatch(this.cluster);
        this.indexEngine.rename(this.kObjectKey, this.kObject);
        ((IndexProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).rename((String)Matchers.any(), (String)Matchers.any(), (KObject)Matchers.same((Object)this.kObject));
    }

    @Test
    public void renameCalledWhenBatchCommitted() throws Exception {
        this.renameDeferredInBatchMode();
        this.indexEngine.commit(this.cluster, TEST_INDEXER);
        ((IndexProvider)Mockito.verify((Object)this.provider)).rename((String)Matchers.any(), (String)Matchers.any(), (KObject)Matchers.same((Object)this.kObject));
    }

    @Test
    public void renameNeverCalledWhenBatchAborted() throws Exception {
        this.renameDeferredInBatchMode();
        this.indexEngine.abort(this.cluster);
        ((IndexProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).rename((String)Matchers.any(), (String)Matchers.any(), (KObject)Matchers.same((Object)this.kObject));
    }

    @Test
    public void deleteDeferredInBatchMode() throws Exception {
        this.indexEngine.startBatch(this.cluster);
        this.indexEngine.delete(this.kObjectKey);
        ((IndexProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).delete(this.kObjectKey.getClusterId(), this.kObjectKey.getId());
    }

    @Test
    public void deleteCalledWhenBatchCommitted() throws Exception {
        this.deleteDeferredInBatchMode();
        this.indexEngine.commit(this.cluster, TEST_INDEXER);
        ((IndexProvider)Mockito.verify((Object)this.provider)).delete(this.kObjectKey.getClusterId(), this.kObjectKey.getId());
    }

    @Test
    public void deleteNeverCalledWhenBatchAborted() throws Exception {
        this.deleteDeferredInBatchMode();
        this.indexEngine.abort(this.cluster);
        ((IndexProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).delete(this.kObjectKey.getClusterId(), this.kObjectKey.getId());
    }

    @Test
    public void indexIsReadyForClusterIndexedInPreviousServerExecution() throws Exception {
        Mockito.when((Object)this.provider.isFreshIndex(this.cluster)).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.indexEngine.isIndexReady(this.cluster, TEST_INDEXER));
    }

    @Test
    public void indexIsReadyAfterCommit() throws Exception {
        Mockito.when((Object)this.provider.isFreshIndex(this.cluster)).thenReturn((Object)false);
        this.indexEngine.startBatch(this.cluster);
        this.indexEngine.index(this.kObject);
        this.indexEngine.commit(this.cluster, TEST_INDEXER);
        Assert.assertTrue((boolean)this.indexEngine.isIndexReady(this.cluster, TEST_INDEXER));
    }

    @Test
    public void indexIsNotReadyForIndexerDuringCommit() throws Exception {
        Mockito.when((Object)this.provider.isFreshIndex(this.cluster)).thenReturn((Object)false);
        Mockito.when((Object)this.lock.isLockedBy(TEST_INDEXER)).thenReturn((Object)true);
        this.indexEngine.startBatch(this.cluster);
        Assert.assertFalse((boolean)this.indexEngine.isIndexReady(this.cluster, TEST_INDEXER));
    }

    @Test
    public void indexIsReadyForOtherIndexerDuringCommit() throws Exception {
        Mockito.when((Object)this.provider.isFreshIndex(this.cluster)).thenReturn((Object)false);
        Mockito.when((Object)this.lock.isLockedBy((String)Matchers.any())).then(inv -> TEST_INDEXER.equals(inv.getArgumentAt(0, String.class)));
        this.indexEngine.startBatch(this.cluster);
        Assert.assertTrue((boolean)this.indexEngine.isIndexReady(this.cluster, "other-indexer"));
    }

    @Test
    public void commitAbortedWhenClusterIsDeleted() throws Exception {
        this.indexEngine.startBatch(this.cluster);
        this.indexEngine.index(this.kObject);
        this.indexEngine.delete(this.cluster);
        this.indexEngine.commit(this.cluster, TEST_INDEXER);
        ((IndexProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).index((KObject)Matchers.any(KObject.class));
    }
}

