/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.ext.metadata.model.schema.MetaProperty;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="infinispan.btm")
public class IOServiceIndexedGitImplTest
extends BaseIndexTest {
    protected final Date dateValue = new Date();

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getSimpleName()};
    }

    @Test
    public void testIndexedFile() throws IOException, InterruptedException {
        this.setupCountDown(2);
        Path path1 = this.getBasePath(this.getSimpleName()).resolve("myIndexedFile.txt");
        this.ioService().write(path1, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return IOServiceIndexedGitImplTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "hello some world jhere";
            }
        }});
        Path path2 = this.getBasePath(this.getSimpleName()).resolve("myOtherIndexedFile.txt");
        this.ioService().write(path2, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "jhere";
            }
        }});
        this.waitForCountDown(1000);
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()));
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").get());
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").get());
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").get());
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").get());
        Assert.assertEquals((long)1L, (long)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").get()).getTypes().size());
        Assert.assertEquals((long)1L, (long)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").get()).getTypes().size());
        Assert.assertTrue((boolean)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").get()).getTypes().contains(String.class));
        Assert.assertTrue((boolean)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").get()).getTypes().contains(Date.class));
        List<String> indices = Arrays.asList(AttributesUtil.toProtobufFormat((String)KObjectUtil.toKCluster((Path)path2).getClusterId()));
        IndexProvider provider = this.config.getIndexProvider();
        long hits = provider.findHitsByQuery(indices, (Query)new TermQuery(new Term("int.hello", "world")));
        Assert.assertEquals((long)1L, (long)hits);
        hits = provider.findHitsByQuery(indices, (Query)new TermQuery(new Term("int.hello", "jhere")));
        Assert.assertEquals((long)2L, (long)hits);
        hits = provider.findHitsByQuery(indices, (Query)new MatchAllDocsQuery());
        Assert.assertEquals((long)2L, (long)hits);
    }
}

