/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="infinispan.btm")
public class IOServiceIndexedDotFileGitInternalImplTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testIndexedGitInternalDotFile() {
        this.setupCountDown(1);
        Path path1 = this.getBasePath(this.getClass().getSimpleName()).resolve(".gitkeep");
        this.ioService().write(path1, "ooooo!", Collections.emptySet(), this.getFileAttributes());
        Path path2 = this.getBasePath(this.getClass().getSimpleName()).resolve("afile");
        this.ioService().write(path2, "ooooo!", Collections.emptySet(), this.getFileAttributes());
        this.waitForCountDown(5000);
        String index = AttributesUtil.toProtobufFormat((String)KObjectUtil.toKCluster((Path)path1).getClusterId());
        TermQuery query = new TermQuery(new Term("name", "value"));
        List hits = this.config.getIndexProvider().findByQuery(Arrays.asList(index), (Query)query, 10);
        Assert.assertEquals((long)1L, (long)hits.size());
        Assert.assertEquals((Object)((KObject)hits.get(0)).getKey(), (Object)path2.toUri().toString());
    }

    private FileAttribute<?>[] getFileAttributes() {
        return new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "name";
            }

            public String value() {
                return "value";
            }
        }};
    }
}

