/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.metadata.engine.IndexerScheduler;
import org.uberfire.ext.metadata.event.IndexEvent;
import org.uberfire.ext.metadata.io.ConstrainedIndexerScheduler;

public class ConstrainedIndexerSchedulerTest {
    private Map<String, TestJob> testJobs;
    private CurrentThreadExecutorService executor;

    @Before
    public void setup() {
        AtomicInteger counter = new AtomicInteger(0);
        this.testJobs = new LinkedHashMap<String, TestJob>();
        this.testJobs.put("f", new TestJob(counter));
        this.testJobs.put("e", new TestJob(counter));
        this.testJobs.put("d", new TestJob(counter));
        this.testJobs.put("c", new TestJob(counter));
        this.testJobs.put("b", new TestJob(counter));
        this.testJobs.put("a", new TestJob(counter));
        this.executor = new CurrentThreadExecutorService();
    }

    @Test
    public void allScheduledWithNoConstraints() throws Exception {
        IndexerScheduler.Factory factory = new ConstrainedIndexerScheduler.ConstraintBuilder().createFactory();
        IndexerScheduler scheduler = factory.create(this.testJobs);
        List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled = scheduler.schedule((ExecutorService)this.executor).collect(Collectors.toList());
        this.assertNumberOfFutures(scheduled);
        this.assertFuturesCompleted(scheduled);
        this.assertCorrectResults(scheduled);
    }

    @Test
    public void lowerPriorityNumberRunFirst() throws Exception {
        IndexerScheduler.Factory factory = new ConstrainedIndexerScheduler.ConstraintBuilder().addPriority("a", -4).addPriority("b", -3).addPriority("c", -2).addPriority("d", -1).addPriority("e", 0).addPriority("f", 1).createFactory();
        IndexerScheduler scheduler = factory.create(this.testJobs);
        List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled = scheduler.schedule((ExecutorService)this.executor).collect(Collectors.toList());
        this.assertNumberOfFutures(scheduled);
        this.assertFuturesCompleted(scheduled);
        this.assertCorrectResults(scheduled);
        this.assertExecutionOrder("a", "b", "c", "d", "e", "f");
    }

    @Test
    public void dependencyOrderIsFollowed() throws Exception {
        IndexerScheduler.Factory factory = new ConstrainedIndexerScheduler.ConstraintBuilder().addConstraint("c", "a").addConstraint("c", "b").addConstraint("d", "c").addConstraint("e", "c").createFactory();
        IndexerScheduler scheduler = factory.create(this.testJobs);
        List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled = scheduler.schedule((ExecutorService)this.executor).collect(Collectors.toList());
        this.assertNumberOfFutures(scheduled);
        this.assertFuturesCompleted(scheduled);
        this.assertCorrectResults(scheduled);
        this.assertExecutionOrder("a", "c", "d");
        this.assertExecutionOrder("b", "c", "e");
    }

    @Test
    public void dependencyOrderAndPrioritiesAreFollowed() throws Exception {
        IndexerScheduler.Factory factory = new ConstrainedIndexerScheduler.ConstraintBuilder().addConstraint("c", "a").addConstraint("c", "b").addConstraint("d", "c").addConstraint("e", "c").addPriority("e", -1).createFactory();
        IndexerScheduler scheduler = factory.create(this.testJobs);
        List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled = scheduler.schedule((ExecutorService)this.executor).collect(Collectors.toList());
        this.assertNumberOfFutures(scheduled);
        this.assertFuturesCompleted(scheduled);
        this.assertCorrectResults(scheduled);
        this.assertExecutionOrder("a", "c", "d");
        this.assertExecutionOrder("b", "c", "e");
        this.assertExecutionOrder("e", "d");
    }

    @Test
    public void transitivePrioritiesRespected() throws Exception {
        IndexerScheduler.Factory factory = new ConstrainedIndexerScheduler.ConstraintBuilder().addConstraint("b", "a").addPriority("a", 1).addPriority("b", -1).createFactory();
        IndexerScheduler scheduler = factory.create(this.testJobs);
        List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled = scheduler.schedule((ExecutorService)this.executor).collect(Collectors.toList());
        this.assertNumberOfFutures(scheduled);
        this.assertFuturesCompleted(scheduled);
        this.assertCorrectResults(scheduled);
        this.assertExecutionOrder("a", "b");
        this.assertExecutionOrder("a", "c");
        this.assertExecutionOrder("a", "d");
        this.assertExecutionOrder("a", "e");
        this.assertExecutionOrder("a", "f");
        this.assertExecutionOrder("b", "c");
        this.assertExecutionOrder("b", "d");
        this.assertExecutionOrder("b", "e");
        this.assertExecutionOrder("b", "f");
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalArgumentExceptionWhenMissingJobForDependency() throws Exception {
        IndexerScheduler.Factory factory = new ConstrainedIndexerScheduler.ConstraintBuilder().addConstraint("b", "a").createFactory();
        this.testJobs.remove("a");
        factory.create(this.testJobs);
    }

    @Test
    public void canBeMissingJobsWithoutDependencies() throws Exception {
        IndexerScheduler.Factory factory = new ConstrainedIndexerScheduler.ConstraintBuilder().addConstraint("b", "a").createFactory();
        this.testJobs.remove("b");
        this.testJobs.remove("c");
        IndexerScheduler scheduler = factory.create(this.testJobs);
        List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled = scheduler.schedule((ExecutorService)this.executor).collect(Collectors.toList());
        this.assertNumberOfFutures(scheduled);
        this.assertFuturesCompleted(scheduled);
        this.assertCorrectResults(scheduled);
    }

    @Test
    public void usesExecutorService() throws Exception {
        IndexerScheduler.Factory factory = new ConstrainedIndexerScheduler.ConstraintBuilder().createFactory();
        this.testJobs.keySet().retainAll(Collections.singleton("a"));
        IndexerScheduler scheduler = factory.create(this.testJobs);
        List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled = scheduler.schedule((ExecutorService)this.executor).collect(Collectors.toList());
        this.assertNumberOfFutures(scheduled);
        this.assertFuturesCompleted(scheduled);
        this.assertCorrectResults(scheduled);
        Assert.assertEquals((String)"The given executor was not used.", (long)1L, (long)this.executor.executeCalls);
    }

    private void assertExecutionOrder(String ... idsInExpectedOrder) {
        Object[] observedOrder = (String[])Arrays.stream(idsInExpectedOrder).map(id -> Pair.newPair((Object)id, (Object)this.testJobs.get(id).getExecutionCounter())).sorted(Comparator.comparingInt(pair -> (Integer)pair.getK2())).map(pair -> (String)pair.getK1()).toArray(String[]::new);
        Assert.assertArrayEquals((String)("Execution of jobs was not in the expected order: Observed: " + Arrays.toString(observedOrder)), (Object[])idsInExpectedOrder, (Object[])observedOrder);
    }

    private void assertCorrectResults(List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled) {
        List<Pair<String, List<IndexEvent>>> results = this.getResults(scheduled);
        List expectedResults = this.testJobs.entrySet().stream().map(entry -> new Pair((Object)((String)entry.getKey()), ((TestJob)entry.getValue()).getWithoutIncrement())).collect(Collectors.toList());
        Assert.assertEquals((String)"Should be results for each submitted job.", (long)expectedResults.size(), (long)results.size());
    }

    private List<Pair<String, List<IndexEvent>>> getResults(List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled) {
        List<Pair<String, List<IndexEvent>>> results = scheduled.stream().map(future -> this.getValue((CompletableFuture<Pair<String, List<IndexEvent>>>)future)).collect(Collectors.toList());
        return results;
    }

    private void assertFuturesCompleted(List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled) {
        Assert.assertEquals((String)"All futures should be complete because of the executor service used.", (long)this.testJobs.size(), (long)scheduled.stream().filter(future -> future.isDone() && !future.isCompletedExceptionally()).count());
    }

    private void assertNumberOfFutures(List<CompletableFuture<Pair<String, List<IndexEvent>>>> scheduled) {
        Assert.assertEquals((String)"Should return as many futures as jobs.", (long)this.testJobs.size(), (long)scheduled.size());
    }

    private Pair<String, List<IndexEvent>> getValue(CompletableFuture<Pair<String, List<IndexEvent>>> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError("Should not be any exceptions extracting values from futures in this test.", e);
        }
    }

    private static class CurrentThreadExecutorService
    extends AbstractExecutorService {
        public int executeCalls = 0;

        private CurrentThreadExecutorService() {
        }

        @Override
        public void shutdown() {
            throw new AssertionError((Object)"Should not be invoked during test.");
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new AssertionError((Object)"Should not be invoked during test.");
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new AssertionError((Object)"Should not be invoked during test.");
        }

        @Override
        public void execute(Runnable command) {
            ++this.executeCalls;
            command.run();
        }
    }

    private static class TestJob
    implements Supplier<List<IndexEvent>> {
        private final List<IndexEvent> retVal = new ArrayList<IndexEvent>();
        private Integer executionIndex = null;
        private AtomicInteger executionCounter;

        TestJob(AtomicInteger executionCounter) {
            this.executionCounter = executionCounter;
        }

        @Override
        public List<IndexEvent> get() {
            this.executionIndex = this.executionCounter.incrementAndGet();
            return this.getWithoutIncrement();
        }

        public List<IndexEvent> getWithoutIncrement() {
            return this.retVal;
        }

        public int getExecutionCounter() {
            if (this.executionIndex == null) {
                throw new AssertionError((Object)"TestJob was never executed.");
            }
            return this.executionIndex;
        }
    }
}

