/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.organizationalunit.manager.client.editor;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerPresenterImpl;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerView;
import org.guvnor.organizationalunit.manager.client.editor.popups.AddOrganizationalUnitPopup;
import org.guvnor.organizationalunit.manager.client.editor.popups.EditOrganizationalUnitPopup;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterCreateOrganizationalUnitEvent;
import org.guvnor.structure.events.AfterDeleteOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class OrganizationalUnitManagerPresenterTest {
    @GwtMock
    private AddOrganizationalUnitPopup addOrganizationalUnitPopup;
    @GwtMock
    private EditOrganizationalUnitPopup editOrganizationalUnitPopup;
    @Mock
    private EventSourceMock<AfterCreateOrganizationalUnitEvent> createOUEvent;
    @Mock
    private EventSourceMock<AfterDeleteOrganizationalUnitEvent> deleteOUEvent;
    @Mock
    private OrganizationalUnitController organizationalUnitController;
    @Mock
    private OrganizationalUnit organizationalUnitA;
    private OrganizationalUnitManagerView view = (OrganizationalUnitManagerView)Mockito.mock(OrganizationalUnitManagerView.class);
    private OrganizationalUnitService mockOUService = (OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class);
    private Caller<OrganizationalUnitService> organizationalUnitService = new CallerMock((Object)this.mockOUService);
    private RepositoryService mockRepositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
    private Caller<RepositoryService> repositoryService = new CallerMock((Object)this.mockRepositoryService);
    private OrganizationalUnitManagerPresenterImpl presenter;
    private OrganizationalUnit mockOU = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);

    @Before
    public void setup() {
        this.presenter = new OrganizationalUnitManagerPresenterImpl(this.view, this.organizationalUnitService, this.repositoryService, this.organizationalUnitController, this.addOrganizationalUnitPopup, this.editOrganizationalUnitPopup, this.createOUEvent, this.deleteOUEvent);
        Mockito.when((Object)this.mockOU.getName()).thenReturn((Object)"mock");
        Mockito.when((Object)this.mockOU.getOwner()).thenReturn((Object)"mock");
        Mockito.when((Object)this.mockOU.getDefaultGroupId()).thenReturn((Object)"mock");
        Mockito.when((Object)this.mockOUService.getOrganizationalUnits()).thenReturn(new ArrayList());
        Mockito.when((Object)this.mockOUService.getOrganizationalUnit(Mockito.anyString())).thenReturn((Object)this.organizationalUnitA);
        Mockito.when((Object)this.mockOUService.createOrganizationalUnit((String)Mockito.any(String.class), (String)Mockito.any(String.class), (String)Mockito.any(String.class), (Collection)Mockito.any(Collection.class))).thenReturn((Object)this.mockOU);
        Mockito.when((Object)this.organizationalUnitController.canCreateOrgUnits()).thenReturn((Object)false);
        Mockito.when((Object)this.organizationalUnitController.canUpdateOrgUnit(this.organizationalUnitA)).thenReturn((Object)true);
        Mockito.when((Object)this.organizationalUnitController.canDeleteOrgUnit(this.organizationalUnitA)).thenReturn((Object)true);
        Mockito.when((Object)this.organizationalUnitA.getRepositories()).thenReturn((Object)Collections.EMPTY_LIST);
        this.presenter.loadOrganizationalUnits();
    }

    @Test
    public void testOnStartup() {
        this.presenter.onStartup();
        ((OrganizationalUnitManagerView)Mockito.verify((Object)this.view)).setAddOrganizationalUnitEnabled(false);
        ((OrganizationalUnitManagerView)Mockito.verify((Object)this.view)).setDeleteOrganizationalUnitEnabled(false);
        ((OrganizationalUnitManagerView)Mockito.verify((Object)this.view)).setDeleteOrganizationalUnitEnabled(false);
    }

    @Test
    public void testSelectOrgUnit() {
        this.presenter.onStartup();
        this.presenter.organizationalUnitSelected(this.organizationalUnitA);
        ((OrganizationalUnitManagerView)Mockito.verify((Object)this.view)).setDeleteOrganizationalUnitEnabled(true);
        ((OrganizationalUnitManagerView)Mockito.verify((Object)this.view)).setDeleteOrganizationalUnitEnabled(true);
    }

    @Test
    public void testCreateOUEvent() {
        this.presenter.createNewOrganizationalUnit(this.mockOU.getName(), this.mockOU.getOwner(), this.mockOU.getDefaultGroupId());
        ((EventSourceMock)Mockito.verify(this.createOUEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(AfterCreateOrganizationalUnitEvent.class));
    }

    @Test
    public void testDeleteOUEvent() {
        this.presenter.deleteOrganizationalUnit(this.mockOU);
        ((EventSourceMock)Mockito.verify(this.deleteOUEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(AfterDeleteOrganizationalUnitEvent.class));
    }
}

