/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.BaseWorkbenchTest;
import org.uberfire.client.mvp.MockWorkbenchScreenActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceManagerImplUnitTestWrapper;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;

public class PanelManagerTest
extends BaseWorkbenchTest {
    @Test
    public void testAddOnePartToRootPanel() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        MockWorkbenchScreenActivity activity = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity));
        Mockito.when((Object)spy.getDefaultPosition()).thenReturn((Object)Position.ROOT);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy, this.panelManager, (Event<SelectPlaceEvent>)((Event)null));
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        Assert.assertNotNull((Object)root);
        Assert.assertTrue((boolean)root.isRoot());
        Assert.assertEquals((long)1L, (long)root.getParts().size());
        Assert.assertNull((Object)root.getChild(Position.NORTH));
        Assert.assertNull((Object)root.getChild(Position.SOUTH));
        Assert.assertNull((Object)root.getChild(Position.EAST));
        Assert.assertNull((Object)root.getChild(Position.WEST));
        Assert.assertEquals((Object)somewhere, (Object)this.getPart(root.getParts(), 0).getPlace());
    }

    @Test
    public void testAddOnePartToRootPanelTwice() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        MockWorkbenchScreenActivity activity = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity));
        Mockito.when((Object)spy.getDefaultPosition()).thenReturn((Object)Position.ROOT);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        Assert.assertNotNull((Object)root);
        Assert.assertTrue((boolean)root.isRoot());
        Assert.assertEquals((long)1L, (long)root.getParts().size());
        Assert.assertNull((Object)root.getChild(Position.NORTH));
        Assert.assertNull((Object)root.getChild(Position.SOUTH));
        Assert.assertNull((Object)root.getChild(Position.EAST));
        Assert.assertNull((Object)root.getChild(Position.WEST));
        Assert.assertEquals((Object)somewhere, (Object)this.getPart(root.getParts(), 0).getPlace());
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        Assert.assertNotNull((Object)root);
        Assert.assertTrue((boolean)root.isRoot());
        Assert.assertEquals((long)1L, (long)root.getParts().size());
        Assert.assertNull((Object)root.getChild(Position.NORTH));
        Assert.assertNull((Object)root.getChild(Position.SOUTH));
        Assert.assertNull((Object)root.getChild(Position.EAST));
        Assert.assertNull((Object)root.getChild(Position.WEST));
        Assert.assertEquals((Object)somewhere, (Object)this.getPart(root.getParts(), 0).getPlace());
    }

    @Test
    public void testAddTwoPartsToRootPanel() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        DefaultPlaceRequest elsewhere = new DefaultPlaceRequest("Elsewhere");
        MockWorkbenchScreenActivity activity1 = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy1 = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity1));
        Mockito.when((Object)spy1.getDefaultPosition()).thenReturn((Object)Position.ROOT);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy1);
            }
        });
        MockWorkbenchScreenActivity activity2 = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy2 = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity2));
        Mockito.when((Object)spy2.getDefaultPosition()).thenReturn((Object)Position.ROOT);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)elsewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy2);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy1, this.panelManager, (Event<SelectPlaceEvent>)((Event)null));
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        Assert.assertNotNull((Object)root);
        Assert.assertTrue((boolean)root.isRoot());
        Assert.assertEquals((long)1L, (long)root.getParts().size());
        Assert.assertNull((Object)root.getChild(Position.NORTH));
        Assert.assertNull((Object)root.getChild(Position.SOUTH));
        Assert.assertNull((Object)root.getChild(Position.EAST));
        Assert.assertNull((Object)root.getChild(Position.WEST));
        Assert.assertEquals((Object)somewhere, (Object)this.getPart(root.getParts(), 0).getPlace());
        this.placeManager.goTo((PlaceRequest)elsewhere, root);
        Assert.assertNotNull((Object)root);
        Assert.assertTrue((boolean)root.isRoot());
        Assert.assertEquals((long)2L, (long)root.getParts().size());
        Assert.assertNull((Object)root.getChild(Position.NORTH));
        Assert.assertNull((Object)root.getChild(Position.SOUTH));
        Assert.assertNull((Object)root.getChild(Position.EAST));
        Assert.assertNull((Object)root.getChild(Position.WEST));
        List<PlaceRequest> places = this.toPlaces(root.getParts());
        Assert.assertTrue((boolean)places.contains(somewhere));
        Assert.assertTrue((boolean)places.contains(elsewhere));
    }

    private List<PlaceRequest> toPlaces(Set<PartDefinition> parts) {
        ArrayList<PlaceRequest> places = new ArrayList<PlaceRequest>();
        for (PartDefinition part : parts) {
            places.add(part.getPlace());
        }
        return places;
    }

    private PartDefinition getPart(Set<PartDefinition> parts, int index) {
        PartDefinition[] arrayParts = new PartDefinition[parts.size()];
        parts.toArray(arrayParts);
        return arrayParts[index];
    }
}

