/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.event.shared.EventBus;
import java.util.HashSet;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.AcceptItem;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.BaseWorkbenchTest;
import org.uberfire.client.mvp.MockWorkbenchScreenActivity;
import org.uberfire.client.mvp.PlaceHistoryHandler;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceManagerImplUnitTestWrapper;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.Position;

public class PlaceManagerImplTest
extends BaseWorkbenchTest {
    @Test
    public void testGoToSomeWhere() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        final WorkbenchEditorActivity activity = (WorkbenchEditorActivity)Mockito.mock(WorkbenchEditorActivity.class);
        HashSet<Activity> activities = new HashSet<Activity>(1){
            {
                super(x0);
                this.add(activity);
            }
        };
        Mockito.when((Object)activity.getDefaultPosition()).thenReturn((Object)Position.ROOT);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)activities);
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)activity, this.panelManager);
        this.placeManager.goTo((PlaceRequest)somewhere);
        ((WorkbenchEditorActivity)Mockito.verify((Object)activity)).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)somewhere), (Command)Matchers.isNull(Command.class));
    }

    @Test
    public void testGoToNoWhere() throws Exception {
        this.placeManager.goTo(DefaultPlaceRequest.NOWHERE);
        Assert.assertTrue((String)"Just checking we get no NPEs", (boolean)true);
    }

    @Test
    public void testPlaceManagerGetInitializedToADefaultPlace() throws Exception {
        this.placeManager = new PlaceManagerImplUnitTestWrapper(this.placeHistoryHandler);
        this.placeManager.initPlaceHistoryHandler();
        ((PlaceHistoryHandler)Mockito.verify((Object)this.placeHistoryHandler)).register((PlaceManager)Matchers.any(PlaceManager.class), (com.google.web.bindery.event.shared.EventBus)Matchers.any(EventBus.class), (PlaceRequest)Matchers.any(PlaceRequest.class));
    }

    @Test
    public void testGoToPreviouslyOpenedPlace() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        MockWorkbenchScreenActivity activity = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity));
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        this.placeManager.goTo((PlaceRequest)somewhere, this.panelManager.getRoot());
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)somewhere), (Command)Matchers.isNull(Command.class));
        ((Event)Mockito.verify((Object)this.selectWorkbenchPartEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SelectPlaceEvent.class));
        DefaultPlaceRequest somewhereSecondCall = new DefaultPlaceRequest("Somewhere");
        this.placeManager.goTo((PlaceRequest)somewhereSecondCall, this.panelManager.getRoot());
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)somewhere), (Command)Matchers.isNull(Command.class));
        ((Event)Mockito.verify((Object)this.selectWorkbenchPartEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(SelectPlaceEvent.class));
    }
}

