/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.HashSet;
import javax.enterprise.event.Event;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.AcceptItem;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.BaseWorkbenchTest;
import org.uberfire.client.mvp.MockWorkbenchScreenActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceManagerImplUnitTestWrapper;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;

public class AbstractWorkbenchScreenActivityTest
extends BaseWorkbenchTest {
    @Test
    public void testGoToOnePlace() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        MockWorkbenchScreenActivity activity = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity));
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy, this.panelManager);
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy)).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)somewhere), (Command)Matchers.isNull(Command.class));
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy)).onStartup((PlaceRequest)Matchers.eq((Object)somewhere));
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy)).onOpen();
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)somewhere), (Command)Matchers.isNull(Command.class));
        ((Event)Mockito.verify((Object)this.selectWorkbenchPartEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SelectPlaceEvent.class));
    }

    @Test
    public void testGoToOnePlaceTwice() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        DefaultPlaceRequest somewhereTheSame = new DefaultPlaceRequest("Somewhere");
        MockWorkbenchScreenActivity activity = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity));
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        this.placeManager.goTo((PlaceRequest)somewhereTheSame, root);
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)somewhere), (Command)Matchers.isNull(Command.class));
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).onStartup((PlaceRequest)Matchers.eq((Object)somewhere));
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).onOpen();
        ((Event)Mockito.verify((Object)this.selectWorkbenchPartEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(SelectPlaceEvent.class));
    }

    @Test
    public void testGoToTwoDifferentPlaces() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        DefaultPlaceRequest somewhereElse = new DefaultPlaceRequest("SomewhereElse");
        MockWorkbenchScreenActivity activity1 = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy1 = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity1));
        MockWorkbenchScreenActivity activity2 = new MockWorkbenchScreenActivity((PlaceManager)this.placeManager);
        final WorkbenchScreenActivity spy2 = (WorkbenchScreenActivity)Mockito.spy((Object)((Object)activity2));
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy1);
            }
        });
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhereElse)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy2);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy1, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy2, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        this.placeManager.goTo((PlaceRequest)somewhereElse, root);
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy1, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)somewhere), (Command)Matchers.isNull(Command.class));
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy1, (VerificationMode)Mockito.times((int)1))).onStartup((PlaceRequest)Matchers.eq((Object)somewhere));
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy1, (VerificationMode)Mockito.times((int)1))).onOpen();
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy2, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)somewhereElse), (Command)Matchers.isNull(Command.class));
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy2, (VerificationMode)Mockito.times((int)1))).onStartup((PlaceRequest)Matchers.eq((Object)somewhereElse));
        ((WorkbenchScreenActivity)Mockito.verify((Object)spy2, (VerificationMode)Mockito.times((int)1))).onOpen();
        ((Event)Mockito.verify((Object)this.selectWorkbenchPartEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(SelectPlaceEvent.class));
    }
}

