/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.ioc.client.container.CreationalContext;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.client.mvp.PlaceRequestHistoryMapperImpl;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

public class PlaceRequestHistoryMapperImplTest {
    private PlaceRequestHistoryMapperImpl placeRequestHistoryMapper;

    @BeforeClass
    public static void registerBean() {
        ObservablePathImpl opath = new ObservablePathImpl();
        IOC.getBeanManager().registerBean((IOCBeanDef)new IOCBeanDef<ObservablePath>((ObservablePath)opath){
            final /* synthetic */ ObservablePath val$opath;
            {
                this.val$opath = observablePath;
            }

            public Class<ObservablePath> getType() {
                return ObservablePath.class;
            }

            public Class<?> getBeanClass() {
                return ObservablePath.class;
            }

            public Class<? extends Annotation> getScope() {
                return null;
            }

            public ObservablePath getInstance() {
                return this.val$opath;
            }

            public ObservablePath getInstance(CreationalContext creationalContext) {
                return this.val$opath;
            }

            public ObservablePath newInstance() {
                return this.val$opath;
            }

            public Set<Annotation> getQualifiers() {
                return Collections.emptySet();
            }

            public boolean matches(Set<Annotation> annotations) {
                return annotations.isEmpty();
            }

            public String getName() {
                return ObservablePath.class.getName();
            }

            public boolean isConcrete() {
                return false;
            }
        });
    }

    @Before
    public void setup() {
        this.placeRequestHistoryMapper = new PlaceRequestHistoryMapperImpl(){

            String urlDecode(String value) {
                return value;
            }
        };
    }

    @Test
    public void createPlaceRequest() throws Exception {
        String url = " http://127.0.0.1:8888/org.uberfire.UberfireShowcase/out.16590-4829.erraiBus?z=12&clientId=16590-4829";
        PlaceRequest placeRequest = this.placeRequestHistoryMapper.getPlaceRequest(url);
        Assert.assertEquals((Object)url, (Object)placeRequest.getFullIdentifier());
        Map parameters = placeRequest.getParameters();
        Assert.assertEquals((Object)"12", parameters.get("z"));
        Assert.assertEquals((Object)"16590-4829", parameters.get("clientId"));
    }

    @Test
    public void createPathPlaceRequest() throws Exception {
        Path path = PathFactory.newPath((String)"file", (String)"default://master@repo/path/to/file");
        PathPlaceRequest placeRequestOriginal = new PathPlaceRequest(path);
        PlaceRequest placeRequest = this.placeRequestHistoryMapper.getPlaceRequest(placeRequestOriginal.getFullIdentifier());
        Assert.assertEquals((Object)placeRequestOriginal.getFullIdentifier(), (Object)placeRequest.getFullIdentifier());
        Assert.assertTrue((boolean)placeRequest.getParameters().isEmpty());
    }

    @Test
    public void createPathPlaceRequestWithSpaces() throws Exception {
        Path path = PathFactory.newPath((String)"Dummy rule.drl", (String)"default://master@uf-playground/mortgages/src/main/resources/org/mortgages/Dummy%20rule.drl");
        PathPlaceRequest placeRequestOriginal = new PathPlaceRequest(path);
        PlaceRequest placeRequest = this.placeRequestHistoryMapper.getPlaceRequest(placeRequestOriginal.getFullIdentifier());
        Assert.assertEquals((Object)placeRequestOriginal.getFullIdentifier(), (Object)placeRequest.getFullIdentifier());
        Assert.assertTrue((boolean)placeRequest.getParameters().isEmpty());
    }
}

