package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.impl.authz.DefaultAuthorizationEntry;

public class Marshaller_o_u_s_i_a_DefaultAuthorizationEntry_1_Impl implements GeneratedMarshaller<DefaultAuthorizationEntry> {
  private DefaultAuthorizationEntry[] EMPTY_ARRAY = new DefaultAuthorizationEntry[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public DefaultAuthorizationEntry[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DefaultAuthorizationEntry demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DefaultAuthorizationEntry.class, objId);
    }
    DefaultAuthorizationEntry entity = new DefaultAuthorizationEntry();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("description")) && (!obj.get("description").isNull())) {
      entity.setDescription(java_lang_String.demarshall(obj.get("description"), a1));
    }
    if ((obj.containsKey("role")) && (!obj.get("role").isNull())) {
      entity.setRole((Role) ((ObjectMarshaller) java_lang_Object).demarshall(Role.class, obj.get("role"), a1));
    }
    if ((obj.containsKey("group")) && (!obj.get("group").isNull())) {
      entity.setGroup((Group) ((ObjectMarshaller) java_lang_Object).demarshall(Group.class, obj.get("group"), a1));
    }
    if ((obj.containsKey("priority")) && (!obj.get("priority").isNull())) {
      entity.setPriority(java_lang_Integer.demarshall(obj.get("priority"), a1));
    }
    if ((obj.containsKey("homePerspective")) && (!obj.get("homePerspective").isNull())) {
      entity.setHomePerspective(java_lang_String.demarshall(obj.get("homePerspective"), a1));
    }
    if ((obj.containsKey("permissions")) && (!obj.get("permissions").isNull())) {
      entity.setPermissions((PermissionCollection) ((ObjectMarshaller) java_lang_Object).demarshall(PermissionCollection.class, obj.get("permissions"), a1));
    }
    return entity;
  }

  public String marshall(DefaultAuthorizationEntry a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"org.uberfire.security.impl.authz.DefaultAuthorizationEntry\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"description\":").append(java_lang_String.marshall(a0.getDescription(), a1)).append(",").append("\"role\":").append(java_lang_Object.marshall(a0.getRole(), a1)).append(",").append("\"group\":").append(java_lang_Object.marshall(a0.getGroup(), a1)).append(",").append("\"priority\":").append(java_lang_Integer.marshall(a0.getPriority(), a1)).append(",").append("\"homePerspective\":").append(java_lang_String.marshall(a0.getHomePerspective(), a1)).append(",").append("\"permissions\":").append(java_lang_Object.marshall(a0.getPermissions(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}