/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationCheck;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.DefaultResourceAction;
import org.uberfire.security.impl.authz.DefaultResourceType;

@ApplicationScoped
public class AuthorizationManagerHelper {
    private AuthorizationManager authorizationManager;
    private User user;

    @Inject
    public AuthorizationManagerHelper(AuthorizationManager authorizationManager, User user) {
        this.authorizationManager = authorizationManager;
        this.user = user;
    }

    private static AuthorizationManagerHelper get() {
        return (AuthorizationManagerHelper)IOC.getBeanManager().lookupBean(AuthorizationManagerHelper.class, new Annotation[0]).getInstance();
    }

    public static boolean authorize(Resource resource) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(resource, helper.getUser());
    }

    public static boolean authorize(Resource resource, String action) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(resource, (ResourceAction)new DefaultResourceAction(action), helper.getUser());
    }

    public static boolean authorize(Resource resource, ResourceAction action) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(resource, action, helper.getUser());
    }

    public static boolean authorize(String resourceType, String action) {
        return AuthorizationManagerHelper.authorize((ResourceType)new DefaultResourceType(resourceType), (ResourceAction)new DefaultResourceAction(action));
    }

    public static boolean authorize(ResourceType resourceType, ResourceAction action) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(resourceType, action, helper.getUser());
    }

    public static boolean authorize(Resource resource, VotingStrategy votingStrategy) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(resource, helper.getUser(), votingStrategy);
    }

    public static boolean authorize(Resource resource, ResourceAction action, VotingStrategy votingStrategy) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(resource, action, helper.getUser(), votingStrategy);
    }

    public static boolean authorize(ResourceType resourceType, ResourceAction action, VotingStrategy votingStrategy) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(resourceType, action, helper.getUser(), votingStrategy);
    }

    public static boolean authorize(String permission) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(permission, helper.getUser());
    }

    public static boolean authorize(Permission permission) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(permission, helper.getUser());
    }

    public static boolean authorize(String permission, VotingStrategy votingStrategy) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(permission, helper.getUser(), votingStrategy);
    }

    public static boolean authorize(Permission permission, VotingStrategy votingStrategy) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().authorize(permission, helper.getUser(), votingStrategy);
    }

    public static AuthorizationCheck check(Resource target) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().check(target, helper.getUser());
    }

    public static AuthorizationCheck check(Resource target, VotingStrategy votingStrategy) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().check(target, helper.getUser(), votingStrategy);
    }

    public static AuthorizationCheck check(String permission) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().check(permission, helper.getUser());
    }

    public static AuthorizationCheck check(String permission, VotingStrategy votingStrategy) {
        AuthorizationManagerHelper helper = AuthorizationManagerHelper.get();
        return helper.getAuthorizationManager().check(permission, helper.getUser(), votingStrategy);
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public User getUser() {
        return this.user;
    }
}

