/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.GeneralTreeProvider;
import org.uberfire.security.client.authz.ProjectTreeProvider;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.client.authz.tree.PermissionTreeFactory;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.PermissionTreeVisitor;
import org.uberfire.security.client.authz.tree.impl.DefaultPermissionTreeFactory;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=MockitoJUnitRunner.class)
public class PermissionTreeTest {
    @Mock
    Resource projectA;
    @Mock
    Resource projectB;
    @Mock
    Instance<PermissionTreeProvider> permissionProviders;
    ProjectTreeProvider projectProvider;
    GeneralTreeProvider generalTreeProvider;
    PermissionTreeFactory permissionTreeFactory;
    PermissionManager permissionManager;

    @Before
    public void setUp() {
        Mockito.when((Object)this.projectA.getIdentifier()).thenReturn((Object)"p1");
        Mockito.when((Object)this.projectB.getIdentifier()).thenReturn((Object)"p2");
        Mockito.when((Object)this.projectA.getResourceType()).thenReturn((Object)ProjectTreeProvider.PROJECT_TYPE);
        Mockito.when((Object)this.projectB.getResourceType()).thenReturn((Object)ProjectTreeProvider.PROJECT_TYPE);
        this.permissionManager = new DefaultPermissionManager();
        this.projectProvider = new ProjectTreeProvider(this.permissionManager, Arrays.asList(this.projectA, this.projectB));
        this.generalTreeProvider = new GeneralTreeProvider(this.permissionManager);
        this.permissionTreeFactory = new DefaultPermissionTreeFactory(this.permissionManager, Arrays.asList(this.generalTreeProvider, this.projectProvider));
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("admin").permission("project.create", Boolean.valueOf(true)).permission("project.read", Boolean.valueOf(false)).permission("project.read.p1", Boolean.valueOf(true)).permission("project.edit", Boolean.valueOf(true)).permission("project.edit.p1", Boolean.valueOf(false)).permission("project.delete", Boolean.valueOf(true)).permission("project.delete.p1", Boolean.valueOf(false)).permission("general.categoryB", Boolean.valueOf(false)).permission("general.categoryB.setting8", Boolean.valueOf(false)).permission("general.categoryB.setting9", Boolean.valueOf(true)).permission("general.categoryB.setting10", Boolean.valueOf(true)).role("manager").permission("project.create", Boolean.valueOf(false)).permission("project.read", Boolean.valueOf(true)).build());
    }

    @Test
    public void testProjectNodeInitialization() {
        PermissionTree tree = this.permissionTreeFactory.createPermissionTree();
        List rootNodes = tree.getRootNodes();
        Assert.assertEquals((long)rootNodes.size(), (long)2L);
        PermissionNode rootNode = (PermissionNode)rootNodes.get(1);
        Assert.assertEquals((Object)rootNode.getNodeName(), (Object)"Projects");
        Assert.assertEquals((long)rootNode.getPermissionList().size(), (long)4L);
        Assert.assertTrue((boolean)(rootNode instanceof PermissionResourceNode));
        Assert.assertEquals((long)rootNode.getLevel(), (long)0L);
        rootNode.expand(children -> {
            Assert.assertEquals((long)children.size(), (long)2L);
            PermissionNode projectNode = (PermissionNode)children.get(0);
            Assert.assertEquals((Object)projectNode.getNodeName(), (Object)"p1");
            Assert.assertTrue((boolean)(projectNode instanceof PermissionLeafNode));
            Assert.assertEquals((long)projectNode.getPermissionList().size(), (long)3L);
            Assert.assertEquals((long)projectNode.getLevel(), (long)1L);
            Assert.assertEquals((long)rootNode.impliesName(projectNode).size(), (long)3L);
            projectNode = (PermissionNode)children.get(1);
            Assert.assertEquals((Object)projectNode.getNodeName(), (Object)"p2");
            Assert.assertTrue((boolean)(projectNode instanceof PermissionLeafNode));
            Assert.assertEquals((long)projectNode.getPermissionList().size(), (long)3L);
            Assert.assertEquals((long)rootNode.impliesName(projectNode).size(), (long)3L);
        });
    }

    @Test
    public void testProjectsLoading() {
        PermissionTree tree = this.permissionTreeFactory.createPermissionTree((Role)new RoleImpl("admin"));
        PermissionNode rootNode = (PermissionNode)tree.getRootNodes().get(1);
        Assert.assertEquals((Object)((Permission)rootNode.getPermissionList().get(0)).getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)((Permission)rootNode.getPermissionList().get(1)).getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        Assert.assertEquals((Object)((Permission)rootNode.getPermissionList().get(2)).getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Assert.assertEquals((Object)((Permission)rootNode.getPermissionList().get(3)).getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        rootNode.expand(children -> {
            Assert.assertEquals((long)children.size(), (long)1L);
            PermissionNode projectNode = (PermissionNode)children.get(0);
            Assert.assertEquals((Object)projectNode.getNodeName(), (Object)"p1");
            Assert.assertEquals((long)projectNode.getPermissionList().size(), (long)3L);
            Assert.assertEquals((Object)((Permission)projectNode.getPermissionList().get(0)).getName(), (Object)"project.read.p1");
            Assert.assertEquals((Object)((Permission)projectNode.getPermissionList().get(1)).getName(), (Object)"project.edit.p1");
            Assert.assertEquals((Object)((Permission)projectNode.getPermissionList().get(2)).getName(), (Object)"project.delete.p1");
            Assert.assertEquals((Object)((Permission)projectNode.getPermissionList().get(0)).getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
            Assert.assertEquals((Object)((Permission)projectNode.getPermissionList().get(1)).getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
            Assert.assertEquals((Object)((Permission)projectNode.getPermissionList().get(2)).getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        });
    }

    @Test
    public void testVisitor() {
        PermissionTree tree = this.permissionTreeFactory.createPermissionTree((Role)new RoleImpl("admin"));
        PermissionTreeVisitor visitor = (PermissionTreeVisitor)Mockito.mock(PermissionTreeVisitor.class);
        tree.accept(visitor);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(PermissionNode.class);
        ((PermissionTreeVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)15))).visit((PermissionNode)argumentCaptor.capture());
        boolean projectsVisited = false;
        boolean p1Visited = false;
        boolean p2Visited = false;
        for (PermissionNode permissionNode : argumentCaptor.getAllValues()) {
            String name = permissionNode.getNodeName();
            if ("Projects".equals(name)) {
                projectsVisited = true;
                continue;
            }
            if ("p1".equals(name)) {
                p1Visited = true;
                Assert.assertEquals((long)permissionNode.getPermissionList().size(), (long)3L);
                Assert.assertEquals((Object)((Permission)permissionNode.getPermissionList().get(0)).getName(), (Object)"project.read.p1");
                Assert.assertEquals((Object)((Permission)permissionNode.getPermissionList().get(1)).getName(), (Object)"project.edit.p1");
                Assert.assertEquals((Object)((Permission)permissionNode.getPermissionList().get(2)).getName(), (Object)"project.delete.p1");
                Assert.assertEquals((Object)((Permission)permissionNode.getPermissionList().get(0)).getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
                Assert.assertEquals((Object)((Permission)permissionNode.getPermissionList().get(1)).getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
                Assert.assertEquals((Object)((Permission)permissionNode.getPermissionList().get(2)).getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
                continue;
            }
            if (!"p2".equals(name)) continue;
            p2Visited = true;
        }
        Assert.assertTrue((boolean)projectsVisited);
        Assert.assertTrue((boolean)p1Visited);
        Assert.assertFalse((boolean)p2Visited);
    }

    @Test
    public void testInheritPermissionValue() {
        PermissionTree tree = this.permissionTreeFactory.createPermissionTree((Role)new RoleImpl("admin"));
        PermissionTreeVisitor visitor = (PermissionTreeVisitor)Mockito.mock(PermissionTreeVisitor.class);
        tree.accept(visitor);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(PermissionNode.class);
        ((PermissionTreeVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)15))).visit((PermissionNode)argumentCaptor.capture());
        for (PermissionNode node : argumentCaptor.getAllValues()) {
            if (!node.getNodeName().equals("Setting 8")) continue;
            Assert.assertEquals((long)node.getPermissionList().size(), (long)1L);
            Permission p = (Permission)node.getPermissionList().get(0);
            Assert.assertEquals((Object)p.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        }
    }
}

