/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;

public class ProjectTreeProvider
implements PermissionTreeProvider {
    public static final ResourceType PROJECT_TYPE = () -> "project";
    public static final ResourceAction PROJECT_CREATE = () -> "create";
    public static final ResourceAction PROJECT_READ = () -> "read";
    public static final ResourceAction PROJECT_EDIT = () -> "edit";
    public static final ResourceAction PROJECT_DELETE = () -> "delete";
    private PermissionManager permissionManager;
    private List<Resource> projectList;

    public ProjectTreeProvider(PermissionManager permissionManager, List<Resource> projectList) {
        this.permissionManager = permissionManager;
        this.projectList = projectList;
    }

    public PermissionNode buildRootNode() {
        PermissionResourceNode rootNode = new PermissionResourceNode("Project", (PermissionTreeProvider)this);
        rootNode.setNodeName("Projects");
        rootNode.addPermission(this.newPermission(PROJECT_CREATE), "Create");
        rootNode.addPermission(this.newPermission(PROJECT_READ), "Read");
        rootNode.addPermission(this.newPermission(PROJECT_EDIT), "Edit");
        rootNode.addPermission(this.newPermission(PROJECT_DELETE), "Delete");
        return rootNode;
    }

    public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback callback) {
        if (parent.getNodeName().equals("Projects")) {
            List nodes = this.getAllProjects().stream().filter(p -> this.match((Resource)p, options)).map(this::toProjectNode).collect(Collectors.toList());
            callback.afterLoad(nodes);
        }
    }

    private Permission newPermission(ResourceAction action) {
        return this.permissionManager.createPermission(PROJECT_TYPE, action, true);
    }

    private Permission newPermission(Resource resource, ResourceAction action) {
        return this.permissionManager.createPermission(resource, action, true);
    }

    private boolean match(Resource project, LoadOptions options) {
        Collection includedIds = options.getResourceIds();
        if (includedIds == null || includedIds.isEmpty()) {
            return true;
        }
        for (String resourceId : includedIds) {
            if (!project.getIdentifier().contains(resourceId)) continue;
            return true;
        }
        return false;
    }

    private PermissionNode toProjectNode(Resource project) {
        PermissionLeafNode node = new PermissionLeafNode();
        node.setNodeName(project.getIdentifier());
        node.addPermission(this.newPermission(project, PROJECT_READ), "Read");
        node.addPermission(this.newPermission(project, PROJECT_EDIT), "Edit");
        node.addPermission(this.newPermission(project, PROJECT_DELETE), "Delete");
        return node;
    }

    private List<Resource> getAllProjects() {
        return this.projectList;
    }
}

