/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz.tree.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.client.authz.tree.PermissionTreeVisitor;

public class DefaultPermissionTree
implements PermissionTree {
    private PermissionManager permissionManager;
    private List<PermissionNode> rootNodes;
    private PermissionCollection permissions;

    public DefaultPermissionTree(PermissionManager permissionManager, List<PermissionNode> rootNodes, PermissionCollection permissions) {
        this.permissionManager = permissionManager;
        this.rootNodes = rootNodes;
        this.permissions = permissions;
        this.init();
    }

    private void init() {
        for (PermissionNode rootNode : this.rootNodes) {
            rootNode.setPermissionTree(this);
            rootNode.updatePermissionList(this.permissions);
        }
    }

    @Override
    public List<PermissionNode> getRootNodes() {
        return Collections.unmodifiableList(this.rootNodes);
    }

    @Override
    public PermissionCollection getPermissions() {
        return this.permissions;
    }

    @Override
    public Collection<String> getChildrenResourceIds(PermissionNode node) {
        HashSet<String> result = new HashSet<String>();
        for (Permission permission : this.getChildrenPermissions(node)) {
            String id = this.permissionManager.resolveResourceId(permission);
            if (id == null) continue;
            result.add(id);
        }
        return result;
    }

    public Set<Permission> getChildrenPermissions(PermissionNode parent) {
        List<Permission> permissionInTree = parent.getPermissionList();
        if (permissionInTree == null || this.permissions == null || this.permissions.collection().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Permission> result = new HashSet<Permission>();
        for (Permission parentPermission : permissionInTree) {
            for (Permission p : this.permissions.collection()) {
                if (!parentPermission.impliesName(p) || parentPermission.impliesResult(p)) continue;
                result.add(p);
            }
        }
        return result;
    }

    @Override
    public void accept(PermissionTreeVisitor visitor) {
        for (PermissionNode rootNode : this.rootNodes) {
            this.accept(visitor, rootNode);
        }
    }

    public void accept(PermissionTreeVisitor visitor, PermissionNode node) {
        visitor.visit(node);
        node.expand(children -> this.accept(visitor, children));
    }

    public void accept(PermissionTreeVisitor visitor, List<PermissionNode> children) {
        for (PermissionNode child : children) {
            this.accept(visitor, child);
        }
    }
}

