/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz;

import java.util.ArrayList;
import java.util.List;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionGroupNode;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;

public class GeneralTreeProvider
implements PermissionTreeProvider {
    private PermissionManager permissionManager;

    public GeneralTreeProvider(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public PermissionNode buildRootNode() {
        PermissionGroupNode rootNode = new PermissionGroupNode((PermissionTreeProvider)this);
        rootNode.setNodeName("General");
        return rootNode;
    }

    public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback callback) {
        if (parent.getNodeName().equals("General")) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.addAll(this.buildSettingNodes(null, 1, 2));
            PermissionGroupNode categoryA = new PermissionGroupNode();
            categoryA.setNodeName("Category A");
            result.add(categoryA);
            PermissionGroupNode categoryB = new PermissionGroupNode();
            categoryB.setNodeName("Category B");
            Permission p = this.permissionManager.createPermission("general.categoryB", true);
            categoryB.addPermission(p, "Allow", "Deny");
            result.add(categoryB);
            callback.afterLoad(result);
        } else if (parent.getNodeName().equals("Category A")) {
            callback.afterLoad(this.buildSettingNodes("A", 3, 5));
        } else if (parent.getNodeName().equals("Category B")) {
            callback.afterLoad(this.buildSettingNodes("B", 8, 3));
        }
    }

    private List<PermissionNode> buildSettingNodes(String id, int from, int n) {
        ArrayList<PermissionNode> result = new ArrayList<PermissionNode>();
        for (int i = from; i < from + n; ++i) {
            PermissionLeafNode setting = new PermissionLeafNode();
            setting.setNodeName("Setting " + i);
            String name = "general" + (id != null ? ".category" + id : "") + ".setting" + i;
            Permission p = this.permissionManager.createPermission(name, true);
            setting.addPermission(p, "Allow", "Deny");
            result.add((PermissionNode)setting);
        }
        return result;
    }
}

