/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.RoleManager;
import org.uberfire.ext.security.management.api.RoleManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.search.RolesRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.RuntimeSearchEngine;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

@Dependent
@Named(value="uberfireRoleManager")
public class UberfireRoleManager
implements RoleManager,
ContextualManager {
    UserSystemManager userSystemManager;
    RuntimeSearchEngine<Role> rolesSearchEngine;

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.userSystemManager = userSystemManager;
        this.rolesSearchEngine = new RolesRuntimeSearchEngine();
    }

    public AbstractEntityManager.SearchResponse<Role> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        return this.rolesSearchEngine.search(this.getRegisteredRoles(), request);
    }

    public Role get(String identifier) throws SecurityManagementException {
        throw new UnsupportedOperationException("Get operation is not available when using the UberfireRoleManager provider.");
    }

    public Role create(Role entity) throws SecurityManagementException {
        throw new UnsupportedOperationException("Create operation is not available when using the UberfireRoleManager provider.");
    }

    public Role update(Role entity) throws SecurityManagementException {
        throw new UnsupportedOperationException("Update operation is not available when using the UberfireRoleManager provider.");
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        throw new UnsupportedOperationException("Delete operation is not available when using the UberfireRoleManager provider.");
    }

    public RoleManagerSettings getSettings() {
        return null;
    }

    public void destroy() throws Exception {
    }

    protected Set<Role> getRegisteredRoles() {
        LinkedHashSet<Role> result = new LinkedHashSet<Role>();
        Set<Role> registeredRoles = SecurityManagementUtils.getRegisteredRoles();
        if (null != registeredRoles && !registeredRoles.isEmpty()) {
            for (Role registeredRole : registeredRoles) {
                if (!this.existGroup(registeredRole.getName())) continue;
                result.add(registeredRole);
            }
        }
        return result;
    }

    protected boolean existGroup(String name) {
        try {
            GroupManager groupManager = this.userSystemManager.groups();
            groupManager.get(name);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }
}

