/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management;

import java.util.List;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.ext.security.management.UberfireRoleManager;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class UberfireRoleManagerTest {
    @Mock
    UserSystemManager userSystemManager;
    private UberfireRoleManager tested;

    @Before
    public void setup() throws Exception {
        RoleRegistry.get().clear();
        RoleRegistry.get().registerRole("regRole1");
        RoleRegistry.get().registerRole("regRole2");
        RoleRegistry.get().registerRole("regRole3");
        this.tested = new UberfireRoleManager();
        this.tested.initialize(this.userSystemManager);
    }

    @Test
    public void testSearch() {
        AbstractEntityManager.SearchResponse response = this.tested.search((AbstractEntityManager.SearchRequest)new SearchRequestImpl("", 1, 10));
        Assert.assertNotNull((Object)response);
        int total = response.getTotal();
        Assert.assertEquals((long)total, (long)3L);
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)false);
        List results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)3L);
    }

    @Test
    public void testSearchRoleNotExists() {
        AbstractEntityManager.SearchResponse response = this.tested.search((AbstractEntityManager.SearchRequest)new SearchRequestImpl("", 1, 10));
        Assert.assertNotNull((Object)response);
        int total = response.getTotal();
        Assert.assertEquals((long)total, (long)3L);
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)false);
        List results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)3L);
    }

    @Test
    public void testGetAllRoles() {
        List results = this.tested.getAll();
        Assert.assertEquals((long)results.size(), (long)3L);
    }

    public void testGet() {
        Role role = this.tested.get("regRole1");
        Assert.assertEquals((Object)role, (Object)new RoleImpl("regRole1"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreate() {
        this.tested.create((Role)Mockito.mock(Role.class));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() {
        this.tested.update((Role)Mockito.mock(Role.class));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testDelete() {
        this.tested.delete(new String[]{"regRole1"});
    }
}

