/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.search;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;
import org.uberfire.ext.security.management.search.GroupsRuntimeSearchEngine;

public class GroupsRuntimeSearchEngineTest {
    GroupsRuntimeSearchEngine searchEngine = new GroupsRuntimeSearchEngine();

    @Test(expected=RuntimeException.class)
    public void testSearchPageZero() {
        ArrayList groups = new ArrayList(1);
        SearchRequestImpl request = new SearchRequestImpl("", 0, 5);
        AbstractEntityManager.SearchResponse response = this.searchEngine.search(groups, (AbstractEntityManager.SearchRequest)request);
    }

    @Test
    public void testSearchAll() {
        List<Group> groups = this.createTestGroups("group", 20);
        SearchRequestImpl request = new SearchRequestImpl("", 1, 5);
        AbstractEntityManager.SearchResponse response = this.searchEngine.search(groups, (AbstractEntityManager.SearchRequest)request);
        Assert.assertNotNull((Object)response);
        int total = response.getTotal();
        Assert.assertEquals((long)total, (long)20L);
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)true);
        List results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)5L);
        Group g = (Group)results.get(0);
        Assert.assertEquals((Object)"group0", (Object)g.getName());
        Group g4 = (Group)results.get(4);
        Assert.assertEquals((Object)"group4", (Object)g4.getName());
        request = new SearchRequestImpl("", 4, 5);
        response = this.searchEngine.search(groups, (AbstractEntityManager.SearchRequest)request);
        Assert.assertNotNull((Object)response);
        total = response.getTotal();
        Assert.assertEquals((long)total, (long)20L);
        hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)false);
        results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)5L);
        Group g15 = (Group)results.get(0);
        Assert.assertEquals((Object)"group15", (Object)g15.getName());
        Group g19 = (Group)results.get(4);
        Assert.assertEquals((Object)"group19", (Object)g19.getName());
    }

    @Test
    public void testSearchSingle() {
        List<Group> groups = this.createTestGroups("group", 20);
        SearchRequestImpl request = new SearchRequestImpl("group18", 1, 5);
        AbstractEntityManager.SearchResponse response = this.searchEngine.search(groups, (AbstractEntityManager.SearchRequest)request);
        Assert.assertNotNull((Object)response);
        int total = response.getTotal();
        Assert.assertEquals((long)total, (long)1L);
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)false);
        List results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)1L);
        Group g = (Group)results.get(0);
        Assert.assertEquals((Object)"group18", (Object)g.getName());
    }

    @Test
    public void testSearchMultiple() {
        List<Group> groups = this.createTestGroups("group", 20);
        SearchRequestImpl request = new SearchRequestImpl("group1", 1, 5);
        AbstractEntityManager.SearchResponse response = this.searchEngine.search(groups, (AbstractEntityManager.SearchRequest)request);
        Assert.assertNotNull((Object)response);
        int total = response.getTotal();
        Assert.assertEquals((long)total, (long)11L);
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)true);
        List results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)5L);
        Group g0 = (Group)results.get(0);
        Assert.assertEquals((Object)"group1", (Object)g0.getName());
        Group g10 = (Group)results.get(1);
        Assert.assertEquals((Object)"group10", (Object)g10.getName());
        Group g13 = (Group)results.get(4);
        Assert.assertEquals((Object)"group13", (Object)g13.getName());
        request = new SearchRequestImpl("group1", 2, 5);
        response = this.searchEngine.search(groups, (AbstractEntityManager.SearchRequest)request);
        Assert.assertNotNull((Object)response);
        total = response.getTotal();
        Assert.assertEquals((long)total, (long)11L);
        hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)true);
        results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)5L);
        Group g14 = (Group)results.get(0);
        Assert.assertEquals((Object)"group14", (Object)g14.getName());
        Group g15 = (Group)results.get(1);
        Assert.assertEquals((Object)"group15", (Object)g15.getName());
        Group g18 = (Group)results.get(4);
        Assert.assertEquals((Object)"group18", (Object)g18.getName());
        request = new SearchRequestImpl("group1", 3, 5);
        response = this.searchEngine.search(groups, (AbstractEntityManager.SearchRequest)request);
        Assert.assertNotNull((Object)response);
        total = response.getTotal();
        Assert.assertEquals((long)total, (long)11L);
        hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)false);
        results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)1L);
        Group g19 = (Group)results.get(0);
        Assert.assertEquals((Object)"group19", (Object)g19.getName());
    }

    private List<Group> createTestGroups(String namePrefix, int size) {
        LinkedList<Group> groups = new LinkedList<Group>();
        for (int x = 0; x < size; ++x) {
            Group group = (Group)Mockito.mock(Group.class);
            Mockito.when((Object)group.getName()).thenReturn((Object)(namePrefix + x));
            groups.add(group);
        }
        return groups;
    }
}

