/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.explorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.screens.explorer.UsersExplorerScreen;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.UsersExplorer;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class UsersExplorerScreenTest {
    @Mock
    BaseScreen baseScreen;
    @Mock
    ErrorPopupPresenter errorPopupPresenter;
    @Mock
    UsersExplorer usersExplorer;
    @Mock
    PlaceManager placeManager;
    @Mock
    ClientUserSystemManager clientUserSystemManager;
    @InjectMocks
    UsersExplorerScreen tested;

    @Before
    public void setup() {
        Mockito.when((Object)this.clientUserSystemManager.isUserCapabilityEnabled((Capability)Matchers.any(Capability.class))).thenReturn((Object)true);
    }

    @Test
    public void testGetWidget() {
        Util.assertEquals((Object)this.baseScreen, (Object)this.tested.getWidget());
    }

    @Test
    public void testOnClose() {
        this.tested.onClose();
        ((UsersExplorer)Mockito.verify((Object)this.usersExplorer, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testShow() {
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        ArrayList<MenuItem> menuItemList = new ArrayList<MenuItem>(1);
        menuItemList.add(menuItem);
        Menus menus = (Menus)Mockito.mock(Menus.class);
        Mockito.when((Object)menus.getItems()).thenReturn(menuItemList);
        this.tested.menu = menus;
        this.tested.show();
        ((UsersExplorer)Mockito.verify((Object)this.usersExplorer, (VerificationMode)Mockito.times((int)1))).show();
        ((MenuItem)Mockito.verify((Object)menuItem, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((UsersExplorer)Mockito.verify((Object)this.usersExplorer, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testNewUser() {
        this.tested.newUser();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)Matchers.any(PlaceRequest.class));
    }

    @Test
    public void testShowError() {
        this.tested.showError("error");
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage("error");
    }

    @Test
    public void testOnUserRead() {
        ReadUserEvent readUserEvent = (ReadUserEvent)Mockito.mock(ReadUserEvent.class);
        Mockito.when((Object)readUserEvent.getIdentifier()).thenReturn((Object)"user1");
        this.tested.onUserRead(readUserEvent);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)Matchers.any(PlaceRequest.class));
    }

    @Test
    public void testOnErrorEvent() {
        OnErrorEvent onErrorEvent = (OnErrorEvent)Mockito.mock(OnErrorEvent.class);
        Mockito.when((Object)onErrorEvent.getMessage()).thenReturn((Object)"error1");
        this.tested.onErrorEvent(onErrorEvent);
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage("error1");
    }
}

