/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWorkbenchConstants;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.GroupsExplorer;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="GroupsExplorerScreen")
public class GroupsExplorerScreen {
    public static final String SCREEN_ID = "GroupsExplorerScreen";
    @Inject
    BaseScreen baseScreen;
    @Inject
    ErrorPopupPresenter errorPopupPresenter;
    @Inject
    GroupsExplorer groupsExplorer;
    @Inject
    PlaceManager placeManager;
    @Inject
    ClientUserSystemManager clientUserSystemManager;
    Menus menu = null;

    @PostConstruct
    public void init() {
        this.menu = this.makeMenuBar();
        this.baseScreen.init((IsWidget)this.groupsExplorer);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.show();
    }

    @OnOpen
    public void onOpen() {
    }

    @OnClose
    public void onClose() {
        this.groupsExplorer.clear();
    }

    public void show() {
        boolean canAddGroup = this.clientUserSystemManager.isGroupCapabilityEnabled(Capability.CAN_ADD_GROUP);
        ((MenuItem)this.menu.getItems().get(0)).setEnabled(canAddGroup);
        this.groupsExplorer.show();
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return this.menu;
    }

    private Menus makeMenuBar() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)UsersManagementWorkbenchConstants.INSTANCE.createNewGroup()).respondsWith(this.getNewCommand())).endMenu()).build();
    }

    private Command getNewCommand() {
        return new Command(){

            public void execute() {
                GroupsExplorerScreen.this.newGroup();
            }
        };
    }

    void newGroup() {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("addGroup", "true");
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("GroupEditorScreen", params));
    }

    void showError(String message) {
        this.errorPopupPresenter.showMessage(message);
    }

    void onGroupRead(@Observes ReadGroupEvent readGroupEvent) {
        String name = readGroupEvent.getName();
        this.goToGroupEditorScreen(name);
    }

    void onErrorEvent(@Observes OnErrorEvent onErrorEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)onErrorEvent);
        Throwable cause = onErrorEvent.getCause();
        String message = onErrorEvent.getMessage();
        String m = message != null ? message : cause.getMessage();
        this.errorPopupPresenter.showMessage(m);
    }

    private void goToGroupEditorScreen(String name) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("groupName", name);
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("GroupEditorScreen", params));
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return UsersManagementWorkbenchConstants.INSTANCE.groupsExplorer();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.baseScreen;
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "groupsExplorerContext";
    }
}

