/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWorkbenchConstants;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.UsersExplorer;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="UsersExplorerScreen")
public class UsersExplorerScreen {
    public static final String SCREEN_ID = "UsersExplorerScreen";
    @Inject
    BaseScreen baseScreen;
    @Inject
    ErrorPopupPresenter errorPopupPresenter;
    @Inject
    UsersExplorer usersExplorer;
    @Inject
    PlaceManager placeManager;
    @Inject
    ClientUserSystemManager clientUserSystemManager;
    Menus menu = null;

    @PostConstruct
    public void init() {
        this.menu = this.makeMenuBar();
        this.baseScreen.init((IsWidget)this.usersExplorer);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.show();
    }

    @OnOpen
    public void onOpen() {
    }

    @OnClose
    public void onClose() {
        this.usersExplorer.clear();
    }

    public void show() {
        boolean canAddUser = this.clientUserSystemManager.isUserCapabilityEnabled(Capability.CAN_ADD_USER);
        ((MenuItem)this.menu.getItems().get(0)).setEnabled(canAddUser);
        this.usersExplorer.show();
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return this.menu;
    }

    private Menus makeMenuBar() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)UsersManagementWorkbenchConstants.INSTANCE.createNewUser()).respondsWith(this.getNewCommand())).endMenu()).build();
    }

    private Command getNewCommand() {
        return new Command(){

            public void execute() {
                UsersExplorerScreen.this.newUser();
            }
        };
    }

    void newUser() {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("addUser", "true");
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("UserEditorScreen", params));
    }

    void showError(String message) {
        this.errorPopupPresenter.showMessage(message);
    }

    void onUserRead(@Observes ReadUserEvent readUserEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)readUserEvent);
        String id = readUserEvent.getIdentifier();
        this.goToUserEditorScreen(id);
    }

    void onErrorEvent(@Observes OnErrorEvent onErrorEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)onErrorEvent);
        Throwable cause = onErrorEvent.getCause();
        String message = onErrorEvent.getMessage();
        String m = message != null ? message : cause.getMessage();
        this.errorPopupPresenter.showMessage(m);
    }

    private void goToUserEditorScreen(String id) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("userId", id);
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("UserEditorScreen", params));
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return UsersManagementWorkbenchConstants.INSTANCE.usersExplorer();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.baseScreen;
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "usersExplorerContext";
    }
}

