/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.editor;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWorkbenchConstants;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow.GroupCreationWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow.GroupEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteGroupEvent;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="GroupEditorScreen")
public class GroupEditorScreen {
    public static final String SCREEN_ID = "GroupEditorScreen";
    public static final String GROUP_NAME = "groupName";
    public static final String ADD_GROUP = "addGroup";
    @Inject
    PlaceManager placeManager;
    @Inject
    Event<ChangeTitleWidgetEvent> changeTitleNotification;
    @Inject
    ErrorPopupPresenter errorPopupPresenter;
    @Inject
    BaseScreen baseScreen;
    @Inject
    GroupEditorWorkflow groupEditorWorkflow;
    @Inject
    GroupCreationWorkflow groupCreationWorkflow;
    @Inject
    ClientUserSystemManager clientUserSystemManager;
    private String title;
    private PlaceRequest placeRequest;
    String groupName;

    @PostConstruct
    public void init() {
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
        String addGroup = placeRequest.getParameter(ADD_GROUP, "false");
        this.groupName = placeRequest.getParameter(GROUP_NAME, null);
        if (Boolean.valueOf(addGroup).booleanValue()) {
            this.create();
        } else {
            this.show();
        }
    }

    @OnOpen
    public void onOpen() {
    }

    @OnClose
    public void onClose() {
        this.groupEditorWorkflow.clear();
        this.groupCreationWorkflow.clear();
        this.groupName = null;
    }

    void showError(String message) {
        this.errorPopupPresenter.showMessage(message);
    }

    void show() {
        this.title = UsersManagementWorkbenchConstants.INSTANCE.showGroup(this.groupName);
        this.baseScreen.init((IsWidget)this.groupEditorWorkflow);
        this.groupEditorWorkflow.show(this.groupName);
    }

    void create() {
        this.groupName = null;
        this.title = UsersManagementWorkbenchConstants.INSTANCE.createNewGroup();
        this.baseScreen.init((IsWidget)this.groupCreationWorkflow);
        this.groupCreationWorkflow.create();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.baseScreen;
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "groupEditorContext";
    }

    void onGroupDeleted(@Observes DeleteGroupEvent deleteGroupEvent) {
        String deletedGroup = deleteGroupEvent.getName();
        if (this.groupName != null && this.groupName.equals(deletedGroup)) {
            this.closeEditor();
        }
    }

    private void closeEditor() {
        this.placeManager.closePlace(this.placeRequest);
    }
}

