/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.editor;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWorkbenchConstants;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.UserCreationWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.UserEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.events.ContextualEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnShowEvent;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="UserEditorScreen")
public class UserEditorScreen {
    public static final String SCREEN_ID = "UserEditorScreen";
    public static final String USER_ID = "userId";
    public static final String ADD_USER = "addUser";
    @Inject
    PlaceManager placeManager;
    @Inject
    Event<ChangeTitleWidgetEvent> changeTitleNotification;
    @Inject
    ErrorPopupPresenter errorPopupPresenter;
    @Inject
    BaseScreen baseScreen;
    @Inject
    ClientUserSystemManager clientUserSystemManager;
    @Inject
    UserEditorWorkflow userEditorWorkflow;
    @Inject
    UserCreationWorkflow userCreationWorkflow;
    private String title = UsersManagementWorkbenchConstants.INSTANCE.userEditor();
    private PlaceRequest placeRequest;
    String userId;

    @PostConstruct
    public void init() {
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
        String addUser = placeRequest.getParameter(ADD_USER, "false");
        String userId = placeRequest.getParameter(USER_ID, null);
        if (Boolean.valueOf(addUser).booleanValue()) {
            this.create();
        } else {
            this.show(userId);
        }
    }

    @OnOpen
    public void onOpen() {
    }

    @OnClose
    public void onClose() {
        this.userEditorWorkflow.clear();
        this.userCreationWorkflow.clear();
        this.userId = null;
    }

    void show(String id) {
        this.baseScreen.init((IsWidget)this.userEditorWorkflow);
        this.userEditorWorkflow.show(id);
    }

    void create() {
        this.title = UsersManagementWorkbenchConstants.INSTANCE.createNewUser();
        this.baseScreen.init((IsWidget)this.userCreationWorkflow);
        this.userCreationWorkflow.create();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.baseScreen;
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "userEditorContext";
    }

    void onEditUserEvent(@Observes OnEditEvent onEditEvent) {
        if (this.checkEventContext((ContextualEvent)onEditEvent, this.userEditorWorkflow.getUserEditor())) {
            try {
                User user = (User)onEditEvent.getInstance();
                this.userId = user.getIdentifier();
                this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, new SafeHtmlBuilder().appendEscaped(UsersManagementWorkbenchConstants.INSTANCE.editUser(user.getIdentifier())).toSafeHtml().asString()));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    void onShowUserEvent(@Observes OnShowEvent onShowEvent) {
        if (this.checkEventContext((ContextualEvent)onShowEvent, this.userEditorWorkflow.getUserEditor())) {
            try {
                User user = (User)onShowEvent.getInstance();
                this.userId = user.getIdentifier();
                String title = new SafeHtmlBuilder().appendEscaped(UsersManagementWorkbenchConstants.INSTANCE.showUser(user.getIdentifier())).toSafeHtml().asString();
                this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, title));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    void onUserDeleted(@Observes DeleteUserEvent deleteUserEvent) {
        String deletedId = deleteUserEvent.getIdentifier();
        if (this.userId != null && this.userId.equals(deletedId)) {
            this.closeEditor();
        }
    }

    private boolean checkEventContext(ContextualEvent contextualEvent, Object context) {
        return contextualEvent != null && contextualEvent.getContext() != null && contextualEvent.getContext().equals(context);
    }

    void closeEditor() {
        this.placeManager.closePlace(this.placeRequest);
    }

    void showError(String message) {
        this.errorPopupPresenter.showMessage(message);
    }
}

