/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.perspectives;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.perspectives.SecurityManagementPerspective;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PerspectiveDefinition;

@RunWith(value=GwtMockitoTestRunner.class)
public class SecurityManagementPerspectiveTest {
    private SecurityManagementPerspective perspective;

    @Before
    public void setup() {
        this.perspective = (SecurityManagementPerspective)Mockito.spy((Object)new SecurityManagementPerspective());
        ((SecurityManagementPerspective)Mockito.doNothing().when((Object)this.perspective)).configurePerspective((PlaceRequest)Matchers.any(PlaceRequest.class));
    }

    @Test
    public void getPerspectiveWithoutStartupTest() {
        PerspectiveDefinition perspectiveDefinition = this.perspective.getPerspective();
        ((SecurityManagementPerspective)Mockito.verify((Object)this.perspective)).createPerspectiveDefinition();
        ((SecurityManagementPerspective)Mockito.verify((Object)this.perspective, (VerificationMode)Mockito.never())).configurePerspective((PlaceRequest)Matchers.any(PlaceRequest.class));
        Assert.assertNotNull((Object)perspectiveDefinition);
        Assert.assertNotNull((Object)perspectiveDefinition.getName());
    }

    @Test
    public void getPerspectiveWithStartupTest() {
        this.perspective.onStartup((PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((SecurityManagementPerspective)Mockito.verify((Object)this.perspective, (VerificationMode)Mockito.times((int)1))).createPerspectiveDefinition();
        ((SecurityManagementPerspective)Mockito.verify((Object)this.perspective, (VerificationMode)Mockito.times((int)1))).configurePerspective((PlaceRequest)Matchers.any(PlaceRequest.class));
        PerspectiveDefinition perspectiveDefinition = this.perspective.getPerspective();
        ((SecurityManagementPerspective)Mockito.verify((Object)this.perspective, (VerificationMode)Mockito.times((int)1))).createPerspectiveDefinition();
        ((SecurityManagementPerspective)Mockito.verify((Object)this.perspective, (VerificationMode)Mockito.times((int)1))).configurePerspective((PlaceRequest)Matchers.any(PlaceRequest.class));
        Assert.assertNotNull((Object)perspectiveDefinition);
        Assert.assertNotNull((Object)perspectiveDefinition.getName());
    }
}

