/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.client.ClientSecurityExceptionMessageResolver;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.screens.explorer.SecurityExplorerScreen;
import org.uberfire.ext.security.management.client.widgets.management.events.NewGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.NewUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadRoleEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.GroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.explorer.RolesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.explorer.UsersExplorer;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class SecurityExplorerScreenTest {
    @Mock
    private SecurityExplorerScreen.View view;
    @Mock
    private RolesExplorer rolesExplorer;
    @Mock
    private GroupsExplorer groupsExplorer;
    @Mock
    private UsersExplorer usersExplorer;
    @Mock
    private ErrorPopupPresenter errorPopupPresenter;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private ClientUserSystemManager userSystemManager;
    private SecurityExplorerScreen tested;

    @Before
    public void setup() {
        ((ClientUserSystemManager)Mockito.doAnswer(invocationOnMock -> {
            ((Command)invocationOnMock.getArguments()[0]).execute();
            return null;
        }).when((Object)this.userSystemManager)).waitForInitialization((Command)ArgumentMatchers.any(Command.class));
        Mockito.when((Object)this.userSystemManager.isActive()).thenReturn((Object)true);
        this.tested = new SecurityExplorerScreen(this.view, this.rolesExplorer, this.groupsExplorer, this.usersExplorer, this.errorPopupPresenter, this.placeManager, this.userSystemManager, new ClientSecurityExceptionMessageResolver());
    }

    @Test
    public void testInit() {
        this.tested.init();
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((SecurityExplorerScreen)ArgumentMatchers.eq((Object)this.tested), (IsWidget)ArgumentMatchers.eq((Object)this.rolesExplorer), (IsWidget)ArgumentMatchers.eq((Object)this.groupsExplorer), (IsWidget)ArgumentMatchers.eq((Object)this.usersExplorer));
        ((RolesExplorer)Mockito.verify((Object)this.rolesExplorer, (VerificationMode)Mockito.times((int)1))).show();
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).rolesEnabled(ArgumentMatchers.eq((boolean)true));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).groupsEnabled(ArgumentMatchers.eq((boolean)false));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).usersEnabled(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testOnStartupUsersTab() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)placeRequest.getParameter((String)ArgumentMatchers.eq((Object)"activeTab"), ArgumentMatchers.anyString())).thenReturn((Object)"UsersTab");
        this.tested.onStartup(placeRequest);
        ((UsersExplorer)Mockito.verify((Object)this.usersExplorer, (VerificationMode)Mockito.times((int)1))).show();
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).show();
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).groupsEnabled(ArgumentMatchers.eq((boolean)true));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).usersEnabled(ArgumentMatchers.eq((boolean)true));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).rolesActive(ArgumentMatchers.eq((boolean)false));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).groupsActive(ArgumentMatchers.eq((boolean)false));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).usersActive(ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testOnStartupGroupsTab() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)placeRequest.getParameter((String)ArgumentMatchers.eq((Object)"activeTab"), ArgumentMatchers.anyString())).thenReturn((Object)"GroupsTab");
        this.tested.onStartup(placeRequest);
        ((UsersExplorer)Mockito.verify((Object)this.usersExplorer, (VerificationMode)Mockito.times((int)1))).show();
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).show();
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).groupsEnabled(ArgumentMatchers.eq((boolean)true));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).usersEnabled(ArgumentMatchers.eq((boolean)true));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).rolesActive(ArgumentMatchers.eq((boolean)false));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).usersActive(ArgumentMatchers.eq((boolean)false));
        ((SecurityExplorerScreen.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).groupsActive(ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testOnClose() {
        this.tested.onClose();
        ((UsersExplorer)Mockito.verify((Object)this.usersExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        ((RolesExplorer)Mockito.verify((Object)this.rolesExplorer, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testOnRoleRead() {
        ReadRoleEvent event = (ReadRoleEvent)Mockito.mock(ReadRoleEvent.class);
        Mockito.when((Object)event.getName()).thenReturn((Object)"someRoleName");
        ArgumentCaptor placeRequestArgumentCaptor = ArgumentCaptor.forClass(DefaultPlaceRequest.class);
        this.tested.onRoleRead(event);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)placeRequestArgumentCaptor.capture());
        DefaultPlaceRequest placeRequest = (DefaultPlaceRequest)placeRequestArgumentCaptor.getValue();
        Assert.assertEquals((Object)"RoleEditorScreen", (Object)placeRequest.getIdentifier());
        Assert.assertEquals((Object)"someRoleName", placeRequest.getParameters().get("roleName"));
    }

    @Test
    public void testOnGroupRead() {
        ReadGroupEvent event = (ReadGroupEvent)Mockito.mock(ReadGroupEvent.class);
        Mockito.when((Object)event.getName()).thenReturn((Object)"someGroupName");
        ArgumentCaptor placeRequestArgumentCaptor = ArgumentCaptor.forClass(DefaultPlaceRequest.class);
        this.tested.onGroupRead(event);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)placeRequestArgumentCaptor.capture());
        DefaultPlaceRequest placeRequest = (DefaultPlaceRequest)placeRequestArgumentCaptor.getValue();
        Assert.assertEquals((Object)"GroupEditorScreen", (Object)placeRequest.getIdentifier());
        Assert.assertEquals((Object)"someGroupName", placeRequest.getParameters().get("groupName"));
        Assert.assertFalse((boolean)placeRequest.getParameters().containsKey("addGroup"));
    }

    @Test
    public void testOnUserRead() {
        ReadUserEvent event = (ReadUserEvent)Mockito.mock(ReadUserEvent.class);
        Mockito.when((Object)event.getIdentifier()).thenReturn((Object)"someUserId");
        ArgumentCaptor placeRequestArgumentCaptor = ArgumentCaptor.forClass(DefaultPlaceRequest.class);
        this.tested.onUserRead(event);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)placeRequestArgumentCaptor.capture());
        DefaultPlaceRequest placeRequest = (DefaultPlaceRequest)placeRequestArgumentCaptor.getValue();
        Assert.assertEquals((Object)"UserEditorScreen", (Object)placeRequest.getIdentifier());
        Assert.assertEquals((Object)"someUserId", placeRequest.getParameters().get("userId"));
        Assert.assertFalse((boolean)placeRequest.getParameters().containsKey("addUser"));
    }

    @Test
    public void testOnGroupCreate() {
        NewGroupEvent event = (NewGroupEvent)Mockito.mock(NewGroupEvent.class);
        ArgumentCaptor placeRequestArgumentCaptor = ArgumentCaptor.forClass(DefaultPlaceRequest.class);
        this.tested.onGroupCreate(event);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)placeRequestArgumentCaptor.capture());
        DefaultPlaceRequest placeRequest = (DefaultPlaceRequest)placeRequestArgumentCaptor.getValue();
        Assert.assertEquals((Object)"GroupEditorScreen", (Object)placeRequest.getIdentifier());
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)placeRequest.getParameters().get("addGroup")));
        Assert.assertFalse((boolean)placeRequest.getParameters().containsKey("groupName"));
    }

    @Test
    public void testOnUserCreate() {
        NewUserEvent event = (NewUserEvent)Mockito.mock(NewUserEvent.class);
        ArgumentCaptor placeRequestArgumentCaptor = ArgumentCaptor.forClass(DefaultPlaceRequest.class);
        this.tested.onUserCreate(event);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)placeRequestArgumentCaptor.capture());
        DefaultPlaceRequest placeRequest = (DefaultPlaceRequest)placeRequestArgumentCaptor.getValue();
        Assert.assertEquals((Object)"UserEditorScreen", (Object)placeRequest.getIdentifier());
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)placeRequest.getParameters().get("addUser")));
        Assert.assertFalse((boolean)placeRequest.getParameters().containsKey("userId"));
    }
}

