/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.screens.editor.UserEditorScreen;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.UserCreationWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.UserEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnShowEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserEditorScreenTest {
    @Mock
    PlaceManager placeManager;
    @Mock
    EventSourceMock<ChangeTitleWidgetEvent> changeTitleNotification;
    @Mock
    ErrorPopupPresenter errorPopupPresenter;
    @Mock
    BaseScreen baseScreen;
    @Mock
    ClientUserSystemManager clientUserSystemManager;
    @Mock
    UserEditorWorkflow userEditorWorkflow;
    @Mock
    UserCreationWorkflow userCreationWorkflow;
    @Mock
    UserEditor userEditor;
    @InjectMocks
    UserEditorScreen tested;
    @Mock
    User user;

    @Before
    public void setup() {
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.clientUserSystemManager.isUserCapabilityEnabled((Capability)ArgumentMatchers.any(Capability.class))).thenReturn((Object)true);
        Mockito.when((Object)this.userEditorWorkflow.getUserEditor()).thenReturn((Object)this.userEditor);
    }

    @Test
    public void testOnStartupAddingUser() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)placeRequest.getParameter("addUser", "false")).thenReturn((Object)"true");
        this.tested.onStartup(placeRequest);
        ((BaseScreen)Mockito.verify((Object)this.baseScreen, (VerificationMode)Mockito.times((int)1))).init((IsWidget)this.userCreationWorkflow);
        ((UserCreationWorkflow)Mockito.verify((Object)this.userCreationWorkflow, (VerificationMode)Mockito.times((int)1))).create();
    }

    @Test
    public void testOnStartupShowingUser() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)placeRequest.getParameter("addUser", "false")).thenReturn((Object)"false");
        Mockito.when((Object)placeRequest.getParameter((String)Mockito.eq((Object)"userId"), (String)Mockito.isNull(String.class))).thenReturn((Object)"user1");
        this.tested.onStartup(placeRequest);
        ((BaseScreen)Mockito.verify((Object)this.baseScreen, (VerificationMode)Mockito.times((int)1))).init((IsWidget)this.userEditorWorkflow);
        ((UserEditorWorkflow)Mockito.verify((Object)this.userEditorWorkflow, (VerificationMode)Mockito.times((int)1))).show("user1");
    }

    @Test
    public void testOnMayCloseSuccess() {
        Mockito.when((Object)this.userEditorWorkflow.isDirty()).thenReturn((Object)false);
        Mockito.when((Object)this.userCreationWorkflow.isDirty()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.tested.onMayClose());
    }

    @Test
    public void testOnMayCloseFailed() {
        Mockito.when((Object)this.userEditorWorkflow.isDirty()).thenReturn((Object)true);
        Mockito.when((Object)this.userCreationWorkflow.isDirty()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.tested.onMayClose());
        Mockito.when((Object)this.userEditorWorkflow.isDirty()).thenReturn((Object)false);
        Mockito.when((Object)this.userCreationWorkflow.isDirty()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.tested.onMayClose());
        Mockito.when((Object)this.userEditorWorkflow.isDirty()).thenReturn((Object)true);
        Mockito.when((Object)this.userCreationWorkflow.isDirty()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.tested.onMayClose());
    }

    @Test
    public void testOnClose() {
        this.tested.userId = "user1";
        this.tested.onClose();
        Assert.assertNull((Object)this.tested.userId);
        ((UserEditorWorkflow)Mockito.verify((Object)this.userEditorWorkflow, (VerificationMode)Mockito.times((int)1))).clear();
        ((UserCreationWorkflow)Mockito.verify((Object)this.userCreationWorkflow, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testShowError() {
        this.tested.showError("error");
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage("error");
    }

    @Test
    public void testOnEditUserEvent() {
        OnEditEvent onEditEvent = (OnEditEvent)Mockito.mock(OnEditEvent.class);
        Mockito.when((Object)onEditEvent.getContext()).thenReturn((Object)this.userEditor);
        Mockito.when((Object)onEditEvent.getInstance()).thenReturn((Object)this.user);
        this.tested.onEditUserEvent(onEditEvent);
        ((EventSourceMock)Mockito.verify(this.changeTitleNotification, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(ChangeTitleWidgetEvent.class));
    }

    @Test
    public void testOnShowUserEvent() {
        OnShowEvent onShowEvent = (OnShowEvent)Mockito.mock(OnShowEvent.class);
        Mockito.when((Object)onShowEvent.getContext()).thenReturn((Object)this.userEditor);
        Mockito.when((Object)onShowEvent.getInstance()).thenReturn((Object)this.user);
        this.tested.onShowUserEvent(onShowEvent);
        ((EventSourceMock)Mockito.verify(this.changeTitleNotification, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(ChangeTitleWidgetEvent.class));
    }

    @Test
    public void testOnUserDeleted() {
        DeleteUserEvent deleteUserEvent = (DeleteUserEvent)Mockito.mock(DeleteUserEvent.class);
        Mockito.when((Object)deleteUserEvent.getIdentifier()).thenReturn((Object)"user1");
        this.tested.userId = "user1";
        this.tested.onUserDeleted(deleteUserEvent);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).closePlace((PlaceRequest)Mockito.any());
    }
}

