/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.exception.EntityNotFoundException;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.NoImplementationAvailableException;
import org.uberfire.ext.security.management.api.exception.RealmManagementNotAuthorizedException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.api.exception.UserAlreadyExistsException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.client.ClientSecurityExceptionMessageResolver;

@RunWith(value=GwtMockitoTestRunner.class)
public class ClientSecurityExceptionMessageResolverTest {
    private ClientSecurityExceptionMessageResolver tested;

    @Before
    public void setup() {
        this.tested = new ClientSecurityExceptionMessageResolver();
        this.tested.registerMessageResolvers();
    }

    @Test
    public void testConsumeSecurityExceptions() {
        Consumer c0 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new SecurityManagementException("custom"), c0);
        ((Consumer)Mockito.verify((Object)c0, (VerificationMode)Mockito.times((int)1))).accept(Matchers.eq((Object)"custom"));
        Consumer c1 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new EntityNotFoundException("id1"), c1);
        ((Consumer)Mockito.verify((Object)c1, (VerificationMode)Mockito.times((int)1))).accept(Matchers.contains((String)"id1"));
        Consumer c2 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new UserNotFoundException("user1"), c2);
        ((Consumer)Mockito.verify((Object)c2, (VerificationMode)Mockito.times((int)1))).accept(Matchers.contains((String)"user1"));
        Consumer c3 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new GroupNotFoundException("group1"), c3);
        ((Consumer)Mockito.verify((Object)c3, (VerificationMode)Mockito.times((int)1))).accept(Matchers.contains((String)"group1"));
        Consumer c4 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new UnsupportedServiceCapabilityException(Capability.CAN_ADD_USER), c4);
        ((Consumer)Mockito.verify((Object)c4, (VerificationMode)Mockito.times((int)1))).accept(Matchers.contains((String)Capability.CAN_ADD_USER.name()));
        Consumer c5 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new UserAlreadyExistsException("aUser"), c5);
        ((Consumer)Mockito.verify((Object)c5, (VerificationMode)Mockito.times((int)1))).accept(Matchers.contains((String)"aUser"));
        Consumer c6 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new RealmManagementNotAuthorizedException("aRealm"), c6);
        ((Consumer)Mockito.verify((Object)c6, (VerificationMode)Mockito.times((int)1))).accept(Matchers.contains((String)"aRealm"));
    }

    @Test
    public void testSkipSecurityExceptions() {
        Consumer c1 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new NoImplementationAvailableException(), c1);
        ((Consumer)Mockito.verify((Object)c1, (VerificationMode)Mockito.never())).accept(Matchers.anyString());
    }

    @Test
    public void testConsumeExceptions() {
        Consumer c1 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new RuntimeException("anErrorMessage"), c1);
        ((Consumer)Mockito.verify((Object)c1, (VerificationMode)Mockito.times((int)1))).accept(Matchers.eq((Object)"anErrorMessage"));
        Consumer c2 = (Consumer)Mockito.mock(Consumer.class);
        this.tested.consumeExceptionMessage((Throwable)new RuntimeException(new RuntimeException("rootMessage")), c2);
        ((Consumer)Mockito.verify((Object)c2, (VerificationMode)Mockito.times((int)1))).accept(Matchers.eq((Object)"rootMessage"));
    }
}

