/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserManagerSettings;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.api.service.RoleManagerService;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.client.ClientSecurityExceptionMessageResolver;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.impl.GroupManagerSettingsImpl;
import org.uberfire.ext.security.management.impl.UserManagerSettingsImpl;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientUserSystemManagerTest {
    private static final String ATTRIBUTE_USER_ID = "user.id";
    private static final String ATTRIBUTE_USER_FIRST_NAME = "user.firstName";
    private static final String ATTRIBUTE_USER_LAST_NAME = "user.lastName";
    private static final String ATTRIBUTE_USER_ENABLED = "user.enabled";
    private static final String ATTRIBUTE_USER_EMAIL = "user.email";
    @Mock
    private ErrorPopupPresenter errorPopupPresenter;
    @Mock
    private UserManagerService userManagerService;
    @Mock
    private GroupManagerService groupsManagerService;
    @Mock
    private RoleManagerService rolesManagerService;
    private Caller<UserManagerService> usersManagerServiceCaller;
    private Caller<GroupManagerService> groupsManagerServiceCaller;
    private Caller<RoleManagerService> rolesManagerServiceCaller;
    private ClientUserSystemManager tested;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        UserManagerSettings userManagerSettings = this.getUserSettings();
        Mockito.when((Object)this.userManagerService.getSettings()).thenReturn((Object)userManagerSettings);
        GroupManagerSettings groupManagerSettings = this.getGroupSettings();
        Mockito.when((Object)this.groupsManagerService.getSettings()).thenReturn((Object)groupManagerSettings);
        this.usersManagerServiceCaller = new CallerMock((Object)this.userManagerService);
        this.groupsManagerServiceCaller = new CallerMock((Object)this.groupsManagerService);
        this.rolesManagerServiceCaller = new CallerMock((Object)this.rolesManagerService);
        this.tested = (ClientUserSystemManager)Mockito.spy((Object)new ClientUserSystemManager(this.usersManagerServiceCaller, this.groupsManagerServiceCaller, this.rolesManagerServiceCaller, new ClientSecurityExceptionMessageResolver(), this.errorPopupPresenter));
    }

    @Test
    public void testInitCache() {
        this.tested.initCache();
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).getSettings();
        ((GroupManagerService)Mockito.verify((Object)this.groupsManagerService, (VerificationMode)Mockito.times((int)1))).getSettings();
    }

    @Test
    public void testIsUserCapabilityEnabled() {
        this.tested.userManagerSettings = this.getUserSettings();
        Assert.assertTrue((boolean)this.tested.isUserCapabilityEnabled(Capability.CAN_READ_USER));
        Assert.assertTrue((boolean)this.tested.isUserCapabilityEnabled(Capability.CAN_ASSIGN_GROUPS));
        Assert.assertFalse((boolean)this.tested.isUserCapabilityEnabled(Capability.CAN_ASSIGN_ROLES));
    }

    @Test
    public void testIsGroupCapabilityEnabled() {
        this.tested.groupManagerSettings = this.getGroupSettings();
        Assert.assertTrue((boolean)this.tested.isGroupCapabilityEnabled(Capability.CAN_READ_GROUP));
        Assert.assertTrue((boolean)this.tested.isGroupCapabilityEnabled(Capability.CAN_ADD_GROUP));
        Assert.assertFalse((boolean)this.tested.isGroupCapabilityEnabled(Capability.CAN_DELETE_GROUP));
    }

    @Test
    public void testGetUserSupportedAttributes() {
        this.tested.userManagerSettings = this.getUserSettings();
        Assert.assertNotNull((Object)this.tested.getUserSupportedAttribute(ATTRIBUTE_USER_ID));
        Assert.assertNull((Object)this.tested.getUserSupportedAttribute("custom-attr"));
    }

    @Test
    public void testGetConstrainedGroups() {
        this.tested.groupManagerSettings = this.getGroupSettings();
        ArrayList<String> cGroups = new ArrayList<String>(1);
        cGroups.add("admin");
        this.tested.groupManagerSettings.setConstrainedGroups(cGroups);
        Assert.assertEquals(cGroups, (Object)this.tested.getConstrainedGroups());
    }

    @Test
    public void testShowError() {
        this.tested.showError((Throwable)new RuntimeException());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
    }

    private UserManagerSettings getUserSettings() {
        return new UserManagerSettingsImpl(this.getUserCapabilities(), this.getUserAttributes());
    }

    private GroupManagerSettings getGroupSettings() {
        return new GroupManagerSettingsImpl(this.getGroupCapabilities(), true);
    }

    private Map<Capability, CapabilityStatus> getUserCapabilities() {
        HashMap<Capability, CapabilityStatus> userCapabilityStatusMap = new HashMap<Capability, CapabilityStatus>();
        userCapabilityStatusMap.put(Capability.CAN_SEARCH_USERS, CapabilityStatus.ENABLED);
        userCapabilityStatusMap.put(Capability.CAN_READ_USER, CapabilityStatus.ENABLED);
        userCapabilityStatusMap.put(Capability.CAN_ADD_USER, CapabilityStatus.ENABLED);
        userCapabilityStatusMap.put(Capability.CAN_UPDATE_USER, CapabilityStatus.ENABLED);
        userCapabilityStatusMap.put(Capability.CAN_DELETE_USER, CapabilityStatus.ENABLED);
        userCapabilityStatusMap.put(Capability.CAN_MANAGE_ATTRIBUTES, CapabilityStatus.ENABLED);
        userCapabilityStatusMap.put(Capability.CAN_ASSIGN_GROUPS, CapabilityStatus.ENABLED);
        userCapabilityStatusMap.put(Capability.CAN_CHANGE_PASSWORD, CapabilityStatus.ENABLED);
        userCapabilityStatusMap.put(Capability.CAN_ASSIGN_ROLES, CapabilityStatus.UNSUPPORTED);
        return userCapabilityStatusMap;
    }

    private Map<Capability, CapabilityStatus> getGroupCapabilities() {
        HashMap<Capability, CapabilityStatus> groupCapabilityStatusMap = new HashMap<Capability, CapabilityStatus>();
        groupCapabilityStatusMap.put(Capability.CAN_SEARCH_GROUPS, CapabilityStatus.ENABLED);
        groupCapabilityStatusMap.put(Capability.CAN_READ_GROUP, CapabilityStatus.ENABLED);
        groupCapabilityStatusMap.put(Capability.CAN_ADD_GROUP, CapabilityStatus.ENABLED);
        groupCapabilityStatusMap.put(Capability.CAN_UPDATE_GROUP, CapabilityStatus.ENABLED);
        groupCapabilityStatusMap.put(Capability.CAN_DELETE_GROUP, CapabilityStatus.UNSUPPORTED);
        return groupCapabilityStatusMap;
    }

    protected Collection<UserManager.UserAttribute> getUserAttributes() {
        ArrayList<UserManager.UserAttribute> attributes = new ArrayList<UserManager.UserAttribute>();
        UserManager.UserAttribute USER_ID = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_ID.getName()).thenReturn((Object)ATTRIBUTE_USER_ID);
        Mockito.when((Object)USER_ID.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)USER_ID.isEditable()).thenReturn((Object)false);
        Mockito.when((Object)USER_ID.getDefaultValue()).thenReturn(null);
        attributes.add(USER_ID);
        UserManager.UserAttribute USER_FIST_NAME = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_FIST_NAME.getName()).thenReturn((Object)ATTRIBUTE_USER_FIRST_NAME);
        Mockito.when((Object)USER_FIST_NAME.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)USER_FIST_NAME.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)USER_FIST_NAME.getDefaultValue()).thenReturn((Object)"First name");
        attributes.add(USER_FIST_NAME);
        UserManager.UserAttribute USER_LAST_NAME = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_LAST_NAME.getName()).thenReturn((Object)ATTRIBUTE_USER_LAST_NAME);
        Mockito.when((Object)USER_LAST_NAME.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)USER_LAST_NAME.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)USER_LAST_NAME.getDefaultValue()).thenReturn((Object)"Last name");
        attributes.add(USER_LAST_NAME);
        UserManager.UserAttribute USER_ENABLED = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_ENABLED.getName()).thenReturn((Object)ATTRIBUTE_USER_ENABLED);
        Mockito.when((Object)USER_ENABLED.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)USER_ENABLED.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)USER_ENABLED.getDefaultValue()).thenReturn((Object)"true");
        attributes.add(USER_ENABLED);
        UserManager.UserAttribute USER_EMAIL = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_EMAIL.getName()).thenReturn((Object)ATTRIBUTE_USER_EMAIL);
        Mockito.when((Object)USER_EMAIL.isMandatory()).thenReturn((Object)false);
        Mockito.when((Object)USER_EMAIL.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)USER_EMAIL.getDefaultValue()).thenReturn((Object)"");
        attributes.add(USER_EMAIL);
        return attributes;
    }
}

