/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.editor.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.validation.EntityValidator;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.user.UserAssignedGroupsExplorer;
import org.uberfire.ext.security.management.client.editor.user.UserAssignedRolesExplorer;
import org.uberfire.ext.security.management.client.editor.user.UserAttributesEditor;
import org.uberfire.ext.security.management.client.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.editor.user.UserEditorDriver;

@RunWith(value=MockitoJUnitRunner.class)
public class UserEditorDriverTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    private UserEditorDriver tested;

    @Before
    public void setup() {
        this.tested = new UserEditorDriver(this.userSystemManager);
    }

    @Test
    public void testCreateUser() {
        final User u = (User)Mockito.mock(User.class);
        final ArgumentCaptor idCaptor = ArgumentCaptor.forClass(String.class);
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                String idArgument = (String)idCaptor.getValue();
                Mockito.when((Object)u.getIdentifier()).thenReturn((Object)idArgument);
                return u;
            }
        }).when((Object)this.userSystemManager)).createUser((String)idCaptor.capture());
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<Collection<UserManager.UserAttribute>>(){

            public Collection<UserManager.UserAttribute> answer(InvocationOnMock invocationOnMock) throws Throwable {
                ArrayList<UserManager.UserAttribute> attributes = new ArrayList<UserManager.UserAttribute>();
                UserManager.UserAttribute a1 = UserEditorDriverTest.this.mockUserAttribute("a1", "v1", true, true);
                UserManager.UserAttribute a2 = UserEditorDriverTest.this.mockUserAttribute("a2", "v2", false, true);
                UserManager.UserAttribute a3 = UserEditorDriverTest.this.mockUserAttribute("a3", "v3", true, false);
                UserManager.UserAttribute a4 = UserEditorDriverTest.this.mockUserAttribute("a4", "v4", false, false);
                attributes.add(a1);
                attributes.add(a2);
                attributes.add(a3);
                attributes.add(a4);
                return attributes;
            }
        }).when((Object)this.userSystemManager)).getUserSupportedAttributes();
        String id = "user1";
        User user = this.tested.createNewUser(id);
        Assert.assertEquals((Object)user, (Object)u);
        Assert.assertEquals((Object)user.getIdentifier(), (Object)u.getIdentifier());
        ((User)Mockito.verify((Object)user, (VerificationMode)Mockito.times((int)1))).setProperty(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void testShow() {
        User user = (User)Mockito.mock(User.class);
        UserEditor userEditor = (UserEditor)Mockito.mock(UserEditor.class);
        UserAttributesEditor attributesEditor = (UserAttributesEditor)Mockito.mock(UserAttributesEditor.class);
        UserAssignedGroupsExplorer groupsExplorer = (UserAssignedGroupsExplorer)Mockito.mock(UserAssignedGroupsExplorer.class);
        UserAssignedRolesExplorer rolesExplorer = (UserAssignedRolesExplorer)Mockito.mock(UserAssignedRolesExplorer.class);
        Mockito.when((Object)userEditor.attributesEditor()).thenReturn((Object)attributesEditor);
        Mockito.when((Object)userEditor.groupsExplorer()).thenReturn((Object)groupsExplorer);
        Mockito.when((Object)userEditor.rolesExplorer()).thenReturn((Object)rolesExplorer);
        this.tested.isFlushed = true;
        this.tested.isEditMode = true;
        this.tested.show(user, userEditor);
        Assert.assertEquals((Object)user, (Object)this.tested.user);
        Assert.assertEquals((Object)userEditor, (Object)this.tested.userEditor);
        Assert.assertFalse((boolean)this.tested.isFlushed);
        Assert.assertFalse((boolean)this.tested.isEditMode);
        ((UserEditor)Mockito.verify((Object)userEditor, (VerificationMode)Mockito.times((int)1))).show((Object)user);
        ((UserAttributesEditor)Mockito.verify((Object)attributesEditor, (VerificationMode)Mockito.times((int)1))).show((Object)user);
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)groupsExplorer, (VerificationMode)Mockito.times((int)1))).show((Object)user);
        ((UserAssignedRolesExplorer)Mockito.verify((Object)rolesExplorer, (VerificationMode)Mockito.times((int)1))).show((Object)user);
        ((UserEditor)Mockito.verify((Object)userEditor, (VerificationMode)Mockito.times((int)0))).edit((Object)user);
        ((UserAttributesEditor)Mockito.verify((Object)attributesEditor, (VerificationMode)Mockito.times((int)0))).edit((Object)user);
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)groupsExplorer, (VerificationMode)Mockito.times((int)0))).edit((Object)user);
        ((UserAssignedRolesExplorer)Mockito.verify((Object)rolesExplorer, (VerificationMode)Mockito.times((int)0))).edit((Object)user);
        ((UserEditor)Mockito.verify((Object)userEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((UserAttributesEditor)Mockito.verify((Object)attributesEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)groupsExplorer, (VerificationMode)Mockito.times((int)0))).flush();
        ((UserAssignedRolesExplorer)Mockito.verify((Object)rolesExplorer, (VerificationMode)Mockito.times((int)0))).flush();
    }

    @Test
    public void testEdit() {
        User user = (User)Mockito.mock(User.class);
        UserEditor userEditor = (UserEditor)Mockito.mock(UserEditor.class);
        UserAttributesEditor attributesEditor = (UserAttributesEditor)Mockito.mock(UserAttributesEditor.class);
        UserAssignedGroupsExplorer groupsExplorer = (UserAssignedGroupsExplorer)Mockito.mock(UserAssignedGroupsExplorer.class);
        UserAssignedRolesExplorer rolesExplorer = (UserAssignedRolesExplorer)Mockito.mock(UserAssignedRolesExplorer.class);
        Mockito.when((Object)userEditor.attributesEditor()).thenReturn((Object)attributesEditor);
        Mockito.when((Object)userEditor.groupsExplorer()).thenReturn((Object)groupsExplorer);
        Mockito.when((Object)userEditor.rolesExplorer()).thenReturn((Object)rolesExplorer);
        this.tested.isFlushed = true;
        this.tested.isEditMode = false;
        this.tested.edit(user, userEditor);
        Assert.assertEquals((Object)user, (Object)this.tested.user);
        Assert.assertEquals((Object)userEditor, (Object)this.tested.userEditor);
        Assert.assertFalse((boolean)this.tested.isFlushed);
        Assert.assertTrue((boolean)this.tested.isEditMode);
        ((UserEditor)Mockito.verify((Object)userEditor, (VerificationMode)Mockito.times((int)1))).edit((Object)user);
        ((UserAttributesEditor)Mockito.verify((Object)attributesEditor, (VerificationMode)Mockito.times((int)1))).edit((Object)user);
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)groupsExplorer, (VerificationMode)Mockito.times((int)1))).edit((Object)user);
        ((UserAssignedRolesExplorer)Mockito.verify((Object)rolesExplorer, (VerificationMode)Mockito.times((int)1))).edit((Object)user);
        ((UserEditor)Mockito.verify((Object)userEditor, (VerificationMode)Mockito.times((int)0))).show((Object)user);
        ((UserAttributesEditor)Mockito.verify((Object)attributesEditor, (VerificationMode)Mockito.times((int)0))).show((Object)user);
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)groupsExplorer, (VerificationMode)Mockito.times((int)0))).show((Object)user);
        ((UserAssignedRolesExplorer)Mockito.verify((Object)rolesExplorer, (VerificationMode)Mockito.times((int)0))).show((Object)user);
        ((UserEditor)Mockito.verify((Object)userEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((UserAttributesEditor)Mockito.verify((Object)attributesEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)groupsExplorer, (VerificationMode)Mockito.times((int)0))).flush();
        ((UserAssignedRolesExplorer)Mockito.verify((Object)rolesExplorer, (VerificationMode)Mockito.times((int)0))).flush();
    }

    @Test
    public void testFlush() {
        User user = (User)Mockito.mock(User.class);
        HashSet roles = new HashSet();
        Mockito.when((Object)user.getRoles()).thenReturn(roles);
        UserEditor userEditor = (UserEditor)Mockito.mock(UserEditor.class);
        UserAttributesEditor attributesEditor = (UserAttributesEditor)Mockito.mock(UserAttributesEditor.class);
        UserAssignedGroupsExplorer groupsExplorer = (UserAssignedGroupsExplorer)Mockito.mock(UserAssignedGroupsExplorer.class);
        UserAssignedRolesExplorer rolesExplorer = (UserAssignedRolesExplorer)Mockito.mock(UserAssignedRolesExplorer.class);
        Mockito.when((Object)userEditor.identifier()).thenReturn((Object)"user1");
        Mockito.when((Object)userEditor.attributesEditor()).thenReturn((Object)attributesEditor);
        HashMap attributes = new HashMap();
        Mockito.when((Object)attributesEditor.getValue()).thenReturn(attributes);
        HashSet groups = new HashSet();
        Mockito.when((Object)userEditor.groupsExplorer()).thenReturn((Object)groupsExplorer);
        Mockito.when((Object)groupsExplorer.getValue()).thenReturn(groups);
        HashSet _roles = new HashSet();
        Mockito.when((Object)userEditor.rolesExplorer()).thenReturn((Object)rolesExplorer);
        Mockito.when((Object)rolesExplorer.getValue()).thenReturn(_roles);
        EntityValidator userEntityValidator = (EntityValidator)Mockito.mock(EntityValidator.class);
        Mockito.when((Object)this.userSystemManager.usersValidator()).thenReturn((Object)userEntityValidator);
        Set violations = (Set)Mockito.mock(Set.class);
        Mockito.when((Object)violations.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)userEntityValidator.validate(Mockito.any(User.class))).thenReturn((Object)violations);
        this.tested.user = user;
        this.tested.userEditor = userEditor;
        this.tested.isFlushed = false;
        this.tested.isEditMode = true;
        this.tested.flush();
        User result = this.tested.getValue();
        ((UserEditor)Mockito.verify((Object)userEditor, (VerificationMode)Mockito.times((int)1))).flush();
        ((UserAttributesEditor)Mockito.verify((Object)attributesEditor, (VerificationMode)Mockito.times((int)1))).flush();
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)groupsExplorer, (VerificationMode)Mockito.times((int)1))).flush();
        ((UserAssignedRolesExplorer)Mockito.verify((Object)rolesExplorer, (VerificationMode)Mockito.times((int)1))).flush();
        ((UserAttributesEditor)Mockito.verify((Object)attributesEditor, (VerificationMode)Mockito.times((int)1))).getValue();
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)groupsExplorer, (VerificationMode)Mockito.times((int)1))).getValue();
        ((UserAssignedRolesExplorer)Mockito.verify((Object)rolesExplorer, (VerificationMode)Mockito.times((int)1))).getValue();
        ((EntityValidator)Mockito.verify((Object)userEntityValidator, (VerificationMode)Mockito.times((int)1))).validate(Mockito.any(User.class));
        Assert.assertEquals((Object)"user1", (Object)result.getIdentifier());
        Assert.assertEquals(roles, (Object)result.getRoles());
        Assert.assertEquals(groups, (Object)result.getGroups());
        Assert.assertEquals(_roles, (Object)result.getRoles());
        Assert.assertEquals(attributes, (Object)result.getProperties());
    }

    private UserManager.UserAttribute mockUserAttribute(String name, String defaultValue, boolean isMandatory, boolean isEditable) {
        UserManager.UserAttribute attr = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)attr.getName()).thenReturn((Object)name);
        Mockito.when((Object)attr.getDefaultValue()).thenReturn((Object)defaultValue);
        Mockito.when((Object)attr.isMandatory()).thenReturn((Object)isMandatory);
        Mockito.when((Object)attr.isEditable()).thenReturn((Object)isEditable);
        return attr;
    }
}

