/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.security.management.keycloak.BaseKeyCloakTest;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleMappingResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleScopeResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UserResource;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class DefaultKeyCloakTest
extends BaseKeyCloakTest {
    public static final String USERNAME = "user";
    public static final String ROLE = "role";
    public static final int rolesCount = 50;
    public static final int usersCount = 30;
    protected final List<RoleResource> roleResources = new ArrayList<RoleResource>();
    protected final List<RoleRepresentation> roleRepresentations = new ArrayList<RoleRepresentation>();
    protected final List<UserResource> userResources = new ArrayList<UserResource>();
    protected final List<UserRepresentation> userRepresentations = new ArrayList<UserRepresentation>();

    @Override
    @Before
    public void setup() throws Exception {
        int x;
        super.setup();
        for (x = 0; x < 50; ++x) {
            String name = ROLE + x;
            RoleResource roleResource = (RoleResource)Mockito.mock(RoleResource.class);
            this.mockRoleResource(roleResource, name);
            this.roleResources.add(roleResource);
            this.roleRepresentations.add(roleResource.toRepresentation());
        }
        Mockito.when((Object)this.rolesResource.get(Matchers.anyString())).thenAnswer((Answer)new Answer<RoleResource>(){

            public RoleResource answer(InvocationOnMock invocationOnMock) throws Throwable {
                String name = (String)invocationOnMock.getArguments()[0];
                return DefaultKeyCloakTest.this.getRole(DefaultKeyCloakTest.this.roleResources, name);
            }
        });
        Mockito.when((Object)this.rolesResource.list()).thenReturn(this.roleRepresentations);
        for (x = 0; x < 30; ++x) {
            String username = USERNAME + x;
            UserResource userResource = (UserResource)Mockito.mock(UserResource.class);
            this.mockUserResource(userResource, username);
            this.userResources.add(userResource);
            this.userRepresentations.add(userResource.toRepresentation());
        }
        Mockito.when((Object)this.usersResource.get(Matchers.anyString())).thenAnswer((Answer)new Answer<UserResource>(){

            public UserResource answer(InvocationOnMock invocationOnMock) throws Throwable {
                String id = (String)invocationOnMock.getArguments()[0];
                return DefaultKeyCloakTest.this.getUser(DefaultKeyCloakTest.this.userResources, id);
            }
        });
        Mockito.when((Object)this.usersResource.search(Matchers.anyString(), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenAnswer((Answer)new Answer<List<UserRepresentation>>(){

            public List<UserRepresentation> answer(InvocationOnMock invocationOnMock) throws Throwable {
                String pattern = (String)invocationOnMock.getArguments()[0];
                Integer start = (Integer)invocationOnMock.getArguments()[1];
                Integer size = (Integer)invocationOnMock.getArguments()[2];
                if (start == 1 && size == Integer.MAX_VALUE) {
                    return DefaultKeyCloakTest.this.userRepresentations;
                }
                List result = DefaultKeyCloakTest.this.getUserRepresentations(pattern, start, size);
                return result;
            }
        });
        Mockito.when((Object)this.usersResource.search(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenAnswer((Answer)new Answer<List<UserRepresentation>>(){

            public List<UserRepresentation> answer(InvocationOnMock invocationOnMock) throws Throwable {
                String pattern = (String)invocationOnMock.getArguments()[0];
                Integer start = (Integer)invocationOnMock.getArguments()[4];
                Integer size = (Integer)invocationOnMock.getArguments()[5];
                List result = DefaultKeyCloakTest.this.getUserRepresentations(pattern, start, size);
                return result;
            }
        });
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        Mockito.when((Object)response.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.usersResource.create((UserRepresentation)Matchers.any(UserRepresentation.class))).thenReturn((Object)response);
    }

    protected ClientResponseFailure mockForbiddenResponse() {
        ClientResponseFailure error = (ClientResponseFailure)Mockito.mock(ClientResponseFailure.class);
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        Response.Status responseStatus = Response.Status.FORBIDDEN;
        Mockito.when((Object)error.getResponse()).thenReturn((Object)response);
        Mockito.when((Object)response.getResponseStatus()).thenReturn((Object)responseStatus);
        return error;
    }

    private List<UserRepresentation> getUserRepresentations(String pattern, int start, int size) {
        List<UserRepresentation> result = null;
        if (this.isEmpty(pattern)) {
            result = this.userRepresentations.subList(start, start + size);
        } else {
            UserResource userResource = this.getUser(this.userResources, pattern);
            if (userResource != null) {
                result = new ArrayList<UserRepresentation>(1);
                result.add(userResource.toRepresentation());
            }
        }
        return result;
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private void mockUserResource(UserResource userResource, String username) {
        UserRepresentation userRepresentation = (UserRepresentation)Mockito.mock(UserRepresentation.class);
        Mockito.when((Object)userResource.toRepresentation()).thenReturn((Object)userRepresentation);
        this.mockUserRepresentation(userRepresentation, username);
        RoleMappingResource roleMappingResource = (RoleMappingResource)Mockito.mock(RoleMappingResource.class);
        Mockito.when((Object)userResource.roles()).thenReturn((Object)roleMappingResource);
        RoleScopeResource roleScopeResource = (RoleScopeResource)Mockito.mock(RoleScopeResource.class);
        Mockito.when((Object)roleMappingResource.realmLevel()).thenReturn((Object)roleScopeResource);
        this.mockRoleMappingResource(roleMappingResource);
    }

    private void mockUserRepresentation(UserRepresentation userRepresentation, String username) {
        Mockito.when((Object)userRepresentation.getUsername()).thenReturn((Object)username);
        String id = username;
        String fName = username.toUpperCase();
        String lName = fName + "Last";
        String mail = username + "@jboss.org";
        Mockito.when((Object)userRepresentation.getId()).thenReturn((Object)id);
        Mockito.when((Object)userRepresentation.getFirstName()).thenReturn((Object)fName);
        Mockito.when((Object)userRepresentation.getLastName()).thenReturn((Object)lName);
        Mockito.when((Object)userRepresentation.getEmail()).thenReturn((Object)mail);
        Mockito.when((Object)userRepresentation.isEmailVerified()).thenReturn((Object)true);
        Mockito.when((Object)userRepresentation.isEnabled()).thenReturn((Object)true);
        HashMap<String, String> attributes = new HashMap<String, String>(6);
        attributes.put("user.id", id);
        attributes.put("user.firstName", fName);
        attributes.put("user.lastName", lName);
        attributes.put("user.enabled", "true");
        attributes.put("user.email", mail);
        attributes.put("user.isEmailVerified", "true");
        Mockito.when((Object)userRepresentation.getAttributes()).thenReturn(attributes);
    }

    private void mockRoleMappingResource(RoleMappingResource roleMappingResource) {
        RoleScopeResource roleScopeResource = (RoleScopeResource)Mockito.mock(RoleScopeResource.class);
        Mockito.when((Object)roleMappingResource.realmLevel()).thenReturn((Object)roleScopeResource);
        this.mockRoleScopeResource(roleScopeResource);
    }

    private void mockRoleScopeResource(RoleScopeResource roleScopeResource) {
        Mockito.when((Object)roleScopeResource.listEffective()).thenReturn(this.roleRepresentations);
    }

    private void mockRoleResource(RoleResource roleResource, String name) {
        RoleRepresentation roleRepresentation = (RoleRepresentation)Mockito.mock(RoleRepresentation.class);
        Mockito.when((Object)roleResource.toRepresentation()).thenReturn((Object)roleRepresentation);
        this.mockRoleRepresentation(roleRepresentation, name);
    }

    private void mockRoleRepresentation(RoleRepresentation roleRepresentation, String name) {
        String id = Integer.toString(name.hashCode());
        String description = "Role " + name;
        Mockito.when((Object)roleRepresentation.getId()).thenReturn((Object)id);
        Mockito.when((Object)roleRepresentation.getName()).thenReturn((Object)name);
        Mockito.when((Object)roleRepresentation.getDescription()).thenReturn((Object)description);
        Mockito.when((Object)roleRepresentation.isComposite()).thenReturn((Object)false);
    }

    private RoleResource getRole(List<RoleResource> roleResources, String name) {
        for (RoleResource roleResource : roleResources) {
            if (!roleResource.toRepresentation().getName().equals(name)) continue;
            return roleResource;
        }
        return null;
    }

    private UserResource getUser(List<UserResource> userResources, String id) {
        for (UserResource userResource : userResources) {
            if (!userResource.toRepresentation().getId().equals(id)) continue;
            return userResource;
        }
        return null;
    }
}

