/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import junit.framework.TestCase;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.RealmManagementNotAuthorizedException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.keycloak.DefaultKeyCloakTest;
import org.uberfire.ext.security.management.keycloak.KeyCloakGroupManager;
import org.uberfire.ext.security.management.keycloak.client.Keycloak;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleMappingResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleScopeResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UserResource;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class KeyCloakGroupManagerTest
extends DefaultKeyCloakTest {
    private KeyCloakGroupManager groupsManager;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.initGroupManager();
        ((KeyCloakGroupManager)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArguments()[0]).accept(this.realmResource);
            return null;
        }).when((Object)this.groupsManager)).consumeRealm((Consumer)Matchers.any(Consumer.class));
    }

    @Test
    public void testCapabilities() {
        TestCase.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_SEARCH_GROUPS), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_READ_GROUP), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_ADD_GROUP), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_DELETE_GROUP), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_UPDATE_GROUP), (Object)CapabilityStatus.UNSUPPORTED);
    }

    @Test
    public void testAllowsEmpty() {
        Assert.assertTrue((boolean)this.groupsManager.getSettings().allowEmpty());
    }

    @Test(expected=RealmManagementNotAuthorizedException.class)
    public void testGroupNotAuthorized() throws Exception {
        this.initGroupManager();
        ((Keycloak)Mockito.doThrow((Throwable)this.mockForbiddenResponse()).when((Object)this.keycloakMock)).realm();
        this.groupsManager.get("role");
    }

    @Test
    public void testGetGroup5() {
        String name = "role5";
        Group group = this.groupsManager.get(name);
        this.assertGroup(group, name);
    }

    @Test(expected=GroupNotFoundException.class)
    public void testGetGroup200() {
        String name = "role200";
        Group group = this.groupsManager.get(name);
    }

    @Test(expected=RuntimeException.class)
    public void testSearchPageZero() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 0, 5);
        AbstractEntityManager.SearchResponse response = this.groupsManager.search(request);
    }

    @Test
    public void testSearchAllFirstPage() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 1, 5);
        AbstractEntityManager.SearchResponse response = this.groupsManager.search(request);
        Assert.assertNotNull((Object)response);
        List groups = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        TestCase.assertEquals((int)total, (int)50);
        Assert.assertTrue((boolean)hasNextPage);
        TestCase.assertEquals((int)groups.size(), (int)5);
        Group group0 = (Group)groups.get(0);
        this.assertGroup(group0, "role0");
        Group group4 = (Group)groups.get(4);
        this.assertGroup(group4, "role4");
    }

    @Test
    public void testSearchAllSecondPage() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 2, 5);
        AbstractEntityManager.SearchResponse response = this.groupsManager.search(request);
        Assert.assertNotNull((Object)response);
        List groups = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        TestCase.assertEquals((int)total, (int)50);
        Assert.assertTrue((boolean)hasNextPage);
        TestCase.assertEquals((int)groups.size(), (int)5);
        Group group5 = (Group)groups.get(0);
        this.assertGroup(group5, "role5");
        Group group9 = (Group)groups.get(4);
        this.assertGroup(group9, "role9");
    }

    @Test
    public void testSearchAllLastPage() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 10, 5);
        AbstractEntityManager.SearchResponse response = this.groupsManager.search(request);
        Assert.assertNotNull((Object)response);
        List groups = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        TestCase.assertEquals((int)total, (int)50);
        Assert.assertTrue((!hasNextPage ? 1 : 0) != 0);
        TestCase.assertEquals((int)groups.size(), (int)5);
        Group group45 = (Group)groups.get(0);
        this.assertGroup(group45, "role45");
        Group group49 = (Group)groups.get(4);
        this.assertGroup(group49, "role49");
    }

    @Test(expected=UnsupportedServiceCapabilityException.class)
    public void testUpdateGroup() {
        this.groupsManager.update(SecurityManagementUtils.createGroup((String)"id1"));
    }

    @Test
    public void testDeleteGroup() {
        RoleResource role0Resource = (RoleResource)this.roleResources.get(0);
        this.groupsManager.delete(new String[]{"role0"});
        ((RoleResource)Mockito.verify((Object)role0Resource, (VerificationMode)Mockito.times((int)1))).remove();
    }

    @Test
    public void testAssignUsers() {
        ArrayList<String> users = new ArrayList<String>();
        users.add("user0");
        UserResource user0Resource = (UserResource)this.userResources.get(0);
        RoleMappingResource roleMappingResource = user0Resource.roles();
        RoleScopeResource roleScopeResource = roleMappingResource.realmLevel();
        this.groupsManager.assignUsers("role0", users);
        ArgumentCaptor rolesCaptor = ArgumentCaptor.forClass(List.class);
        ((RoleScopeResource)Mockito.verify((Object)roleScopeResource, (VerificationMode)Mockito.times((int)1))).add((List)rolesCaptor.capture());
        List rolesAdded = (List)rolesCaptor.getValue();
        TestCase.assertEquals((int)1, (int)rolesAdded.size());
    }

    private void assertGroup(Group group, String name) {
        Assert.assertNotNull((Object)group);
        TestCase.assertEquals((String)name, (String)group.getName());
    }

    private void initGroupManager() throws Exception {
        this.groupsManager = (KeyCloakGroupManager)Mockito.spy((Object)new KeyCloakGroupManager());
        ((KeyCloakGroupManager)Mockito.doReturn((Object)this.keycloakMock).when((Object)this.groupsManager)).getKeyCloakInstance();
        this.groupsManager.initialize(this.userSystemManager);
    }
}

