/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak.client.auth.credentials;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.exception.ResteasyClientException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.keycloak.client.auth.TokenService;
import org.uberfire.ext.security.management.keycloak.client.auth.credentials.AccessTokenResponse;
import org.uberfire.ext.security.management.keycloak.client.auth.credentials.AuthSettings;
import org.uberfire.ext.security.management.keycloak.client.auth.credentials.AuthTokenManager;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthTokenManagerTest {
    @Mock
    AuthSettings config;
    private AuthTokenManager tokenManager;
    private TokenService tokenService;
    private AccessTokenResponse response;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.config.getUsername()).thenReturn((Object)"user1");
        Mockito.when((Object)this.config.getRealm()).thenReturn((Object)"realm1");
        Mockito.when((Object)this.config.getClientId()).thenReturn((Object)"clientId1");
        Mockito.when((Object)this.config.getClientSecret()).thenReturn((Object)"clientSecret1");
        Mockito.when((Object)this.config.getPassword()).thenReturn((Object)"password1");
        Mockito.when((Object)this.config.getServerUrl()).thenReturn((Object)"serverUrl1");
        Mockito.when((Object)this.config.isPublicClient()).thenReturn((Object)false);
        this.tokenManager = (AuthTokenManager)Mockito.spy((Object)new AuthTokenManager(this.config));
        this.tokenService = (TokenService)Mockito.mock(TokenService.class);
        ((AuthTokenManager)Mockito.doReturn((Object)this.tokenService).when((Object)this.tokenManager)).createTokenService();
        this.response = (AccessTokenResponse)Mockito.mock(AccessTokenResponse.class);
        ((TokenService)Mockito.doReturn((Object)this.response).when((Object)this.tokenService)).grantToken(Mockito.anyString(), Mockito.anyString(), (MultivaluedMap)Mockito.any(MultivaluedMap.class));
        Mockito.when((Object)this.response.getRefreshToken()).thenReturn((Object)"refreshToken");
    }

    @Test
    public void testGetRealm() throws Exception {
        String r = this.tokenManager.getRealm();
        Assert.assertEquals((Object)"realm1", (Object)r);
    }

    @Test
    public void testGetAccessTokenString() throws Exception {
        AccessTokenResponse response = (AccessTokenResponse)Mockito.mock(AccessTokenResponse.class);
        Mockito.when((Object)response.getToken()).thenReturn((Object)"token2");
        this.tokenManager.accessTokenResponse = response;
        this.tokenManager.expirationTime = Long.MAX_VALUE;
        this.tokenManager.minTokenValidity = 0L;
        String s = this.tokenManager.getAccessTokenString();
        Assert.assertEquals((Object)"token2", (Object)s);
    }

    @Test
    public void testGrantToken() throws Exception {
        Mockito.when((Object)this.response.getExpiresIn()).thenReturn((Object)1000L);
        this.tokenManager.grantToken();
        ArgumentCaptor mapCaptor = ArgumentCaptor.forClass(MultivaluedMap.class);
        ((TokenService)Mockito.verify((Object)this.tokenService, (VerificationMode)Mockito.times((int)1))).grantToken((String)Mockito.eq((Object)"realm1"), Mockito.anyString(), (MultivaluedMap)mapCaptor.capture());
        MultivaluedMap mvm = (MultivaluedMap)mapCaptor.getValue();
        Assert.assertEquals((Object)"user1", ((List)mvm.get((Object)"username")).get(0));
        Assert.assertEquals((Object)"password1", ((List)mvm.get((Object)"password")).get(0));
    }

    @Test
    public void testGrantPublicToken() throws Exception {
        Mockito.when((Object)this.response.getExpiresIn()).thenReturn((Object)1000L);
        Mockito.when((Object)this.config.isPublicClient()).thenReturn((Object)true);
        this.tokenManager.grantToken();
        ArgumentCaptor mapCaptor = ArgumentCaptor.forClass(MultivaluedMap.class);
        ((TokenService)Mockito.verify((Object)this.tokenService, (VerificationMode)Mockito.times((int)1))).grantToken((String)Mockito.eq((Object)"realm1"), Mockito.anyString(), (MultivaluedMap)mapCaptor.capture());
        MultivaluedMap mvm = (MultivaluedMap)mapCaptor.getValue();
        Assert.assertEquals((Object)"password", ((List)mvm.get((Object)"grant_type")).get(0));
        Assert.assertEquals((Object)"user1", ((List)mvm.get((Object)"username")).get(0));
        Assert.assertEquals((Object)"password1", ((List)mvm.get((Object)"password")).get(0));
        Assert.assertEquals((Object)"clientId1", ((List)mvm.get((Object)"client_id")).get(0));
    }

    @Test
    public void testRefreshToken() throws Exception {
        Mockito.when((Object)this.response.getExpiresIn()).thenReturn((Object)1000L);
        this.tokenManager.accessTokenResponse = this.response;
        this.tokenManager.expirationTime = 0L;
        this.tokenManager.minTokenValidity = 100L;
        String s = this.tokenManager.getAccessTokenString();
        ArgumentCaptor mapCaptor = ArgumentCaptor.forClass(MultivaluedMap.class);
        ((TokenService)Mockito.verify((Object)this.tokenService, (VerificationMode)Mockito.times((int)1))).grantToken((String)Mockito.eq((Object)"realm1"), Mockito.anyString(), (MultivaluedMap)mapCaptor.capture());
        MultivaluedMap mvm = (MultivaluedMap)mapCaptor.getValue();
        Assert.assertEquals((Object)"refresh_token", ((List)mvm.get((Object)"grant_type")).get(0));
        Assert.assertEquals((Object)"refreshToken", ((List)mvm.get((Object)"refresh_token")).get(0));
    }

    @Test
    public void testRefreshPublicToken() throws Exception {
        Mockito.when((Object)this.response.getExpiresIn()).thenReturn((Object)1000L);
        Mockito.when((Object)this.config.isPublicClient()).thenReturn((Object)true);
        this.tokenManager.accessTokenResponse = this.response;
        this.tokenManager.expirationTime = 0L;
        this.tokenManager.minTokenValidity = 100L;
        String s = this.tokenManager.getAccessTokenString();
        ArgumentCaptor mapCaptor = ArgumentCaptor.forClass(MultivaluedMap.class);
        ((TokenService)Mockito.verify((Object)this.tokenService, (VerificationMode)Mockito.times((int)1))).grantToken((String)Mockito.eq((Object)"realm1"), Mockito.anyString(), (MultivaluedMap)mapCaptor.capture());
        MultivaluedMap mvm = (MultivaluedMap)mapCaptor.getValue();
        Assert.assertEquals((Object)"refresh_token", ((List)mvm.get((Object)"grant_type")).get(0));
        Assert.assertEquals((Object)"refreshToken", ((List)mvm.get((Object)"refresh_token")).get(0));
        Assert.assertEquals((Object)"clientId1", ((List)mvm.get((Object)"client_id")).get(0));
    }

    @Test(expected=RuntimeException.class)
    public void testClientError() throws Exception {
        ResteasyClientException exception = (ResteasyClientException)Mockito.mock(ResteasyClientException.class);
        ((TokenService)Mockito.doThrow((Throwable)exception).when((Object)this.tokenService)).grantToken(Mockito.anyString(), Mockito.anyString(), (MultivaluedMap)Mockito.any(MultivaluedMap.class));
        Mockito.when((Object)this.response.getExpiresIn()).thenReturn((Object)1000L);
        Mockito.when((Object)this.config.isPublicClient()).thenReturn((Object)true);
        this.tokenManager.grantToken();
        Assert.assertNull((Object)this.tokenManager.accessTokenResponse);
    }
}

