/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import junit.framework.TestCase;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.exception.RealmManagementNotAuthorizedException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.keycloak.BaseKeyCloakManager;
import org.uberfire.ext.security.management.keycloak.DefaultKeyCloakTest;
import org.uberfire.ext.security.management.keycloak.KeyCloakUserManager;
import org.uberfire.ext.security.management.keycloak.client.Keycloak;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleMappingResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleScopeResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UserResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UsersResource;

@RunWith(value=MockitoJUnitRunner.class)
public class KeyCloakUserManagerTest
extends DefaultKeyCloakTest {
    private KeyCloakUserManager usersManager;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.initUserManager();
        ((KeyCloakUserManager)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArguments()[0]).accept(this.realmResource);
            return null;
        }).when((Object)this.usersManager)).consumeRealm((Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testCapabilities() {
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_SEARCH_USERS), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_READ_USER), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_UPDATE_USER), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_ADD_USER), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_DELETE_USER), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_MANAGE_ATTRIBUTES), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_ASSIGN_GROUPS), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_CHANGE_PASSWORD), (Object)CapabilityStatus.ENABLED);
        TestCase.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_ASSIGN_ROLES), (Object)CapabilityStatus.ENABLED);
    }

    @Test
    public void testAttributes() {
        List<UserManager.UserAttribute> USER_ATTRIBUTES = Arrays.asList(BaseKeyCloakManager.USER_ID, BaseKeyCloakManager.USER_FIST_NAME, BaseKeyCloakManager.USER_LAST_NAME, BaseKeyCloakManager.USER_ENABLED, BaseKeyCloakManager.USER_EMAIL, BaseKeyCloakManager.USER_EMAIL_VERIFIED);
        Collection attributes = this.usersManager.getSettings().getSupportedAttributes();
        TestCase.assertEquals((Object)attributes, USER_ATTRIBUTES);
    }

    @Test(expected=RealmManagementNotAuthorizedException.class)
    public void testUserNotAuthorized() throws Exception {
        this.initUserManager();
        ((Keycloak)Mockito.doThrow((Throwable)this.mockForbiddenResponse()).when((Object)this.keycloakMock)).realm();
        this.usersManager.get("user");
    }

    @Test
    public void testGetUser5() {
        String username = "user5";
        User user = this.usersManager.get(username);
        this.assertUser(user, username);
    }

    @Test(expected=UserNotFoundException.class)
    public void testGetUser50() {
        String username = "user50";
        User user = this.usersManager.get(username);
        Assert.assertNull((Object)user);
    }

    @Test
    public void testGetAllUsers() {
        List users = this.usersManager.getAll();
        Assert.assertEquals((long)30L, (long)users.size());
    }

    @Test(expected=RuntimeException.class)
    public void testSearchPageZero() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 0, 5);
        AbstractEntityManager.SearchResponse response = this.usersManager.search(request);
    }

    @Test
    public void testSearchAllFirstPage() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 1, 5);
        AbstractEntityManager.SearchResponse response = this.usersManager.search(request);
        Assert.assertNotNull((Object)response);
        List users = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        TestCase.assertEquals((int)total, (int)30);
        Assert.assertTrue((boolean)hasNextPage);
        TestCase.assertEquals((int)users.size(), (int)5);
        User user0 = (User)users.get(0);
        this.assertUser(user0, "user0");
        User user4 = (User)users.get(4);
        this.assertUser(user4, "user4");
    }

    @Test
    public void testSearchAllSecondPage() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 2, 5);
        AbstractEntityManager.SearchResponse response = this.usersManager.search(request);
        Assert.assertNotNull((Object)response);
        List users = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        TestCase.assertEquals((int)total, (int)30);
        Assert.assertTrue((boolean)hasNextPage);
        TestCase.assertEquals((int)users.size(), (int)5);
        User user5 = (User)users.get(0);
        this.assertUser(user5, "user5");
        User user9 = (User)users.get(4);
        this.assertUser(user9, "user9");
    }

    @Test
    public void testSearchAllThirdPage() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 3, 5);
        AbstractEntityManager.SearchResponse response = this.usersManager.search(request);
        Assert.assertNotNull((Object)response);
        List users = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        TestCase.assertEquals((int)total, (int)30);
        Assert.assertTrue((boolean)hasNextPage);
        TestCase.assertEquals((int)users.size(), (int)5);
        User user10 = (User)users.get(0);
        this.assertUser(user10, "user10");
        User user14 = (User)users.get(4);
        this.assertUser(user14, "user14");
    }

    @Test
    public void testSearchAllLastPage() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 4, 5);
        AbstractEntityManager.SearchResponse response = this.usersManager.search(request);
        Assert.assertNotNull((Object)response);
        List users = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        TestCase.assertEquals((int)total, (int)30);
        Assert.assertTrue((boolean)hasNextPage);
        TestCase.assertEquals((int)users.size(), (int)5);
        User user15 = (User)users.get(0);
        this.assertUser(user15, "user15");
        User user19 = (User)users.get(4);
        this.assertUser(user19, "user19");
    }

    @Test
    public void testCreateUser() {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user0");
        User userCreated = this.usersManager.create(user);
        Assert.assertNotNull((Object)userCreated);
        ((UsersResource)Mockito.verify((Object)this.usersResource, (VerificationMode)Mockito.times((int)1))).create((UserRepresentation)Mockito.any(UserRepresentation.class));
    }

    @Test
    public void testUpdateUser() {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user0");
        UserResource user0Resource = (UserResource)this.userResources.get(0);
        User userUpdated = this.usersManager.update(user);
        Assert.assertNotNull((Object)userUpdated);
        ((UserResource)Mockito.verify((Object)user0Resource, (VerificationMode)Mockito.times((int)1))).update((UserRepresentation)Mockito.any(UserRepresentation.class));
    }

    @Test
    public void testDeleteUser() {
        UserResource user0Resource = (UserResource)this.userResources.get(0);
        this.usersManager.delete(new String[]{"user0"});
        ((UserResource)Mockito.verify((Object)user0Resource, (VerificationMode)Mockito.times((int)1))).remove();
    }

    @Test
    public void testChangePassword() {
        UserResource user0Resource = (UserResource)this.userResources.get(0);
        this.usersManager.changePassword("user0", "newPassword");
        ((UserResource)Mockito.verify((Object)user0Resource, (VerificationMode)Mockito.times((int)1))).resetPassword((CredentialRepresentation)Mockito.any(CredentialRepresentation.class));
    }

    @Test
    public void testAssignGroups() {
        final User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user0");
        Mockito.when((Object)user.getRoles()).thenReturn(new HashSet());
        UserManager userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        ((UserManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return user;
            }
        }).when((Object)userManagerMock)).get("user0");
        Mockito.when((Object)this.userSystemManager.users()).thenReturn((Object)userManagerMock);
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("role1");
        groups.add("role2");
        UserResource user0Resource = (UserResource)this.userResources.get(0);
        RoleMappingResource roleMappingResource = user0Resource.roles();
        RoleScopeResource roleScopeResource = roleMappingResource.realmLevel();
        this.usersManager.assignGroups("user0", groups);
        ArgumentCaptor rolesCaptor = ArgumentCaptor.forClass(List.class);
        ((RoleScopeResource)Mockito.verify((Object)roleScopeResource, (VerificationMode)Mockito.times((int)1))).add((List)rolesCaptor.capture());
        List rolesAdded = (List)rolesCaptor.getValue();
        TestCase.assertEquals((int)2, (int)rolesAdded.size());
    }

    @Test
    public void testAssignRoles() {
        final User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user0");
        Mockito.when((Object)user.getGroups()).thenReturn(new HashSet());
        UserManager userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        ((UserManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return user;
            }
        }).when((Object)userManagerMock)).get("user0");
        Mockito.when((Object)this.userSystemManager.users()).thenReturn((Object)userManagerMock);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("role1");
        roles.add("role2");
        UserResource user0Resource = (UserResource)this.userResources.get(0);
        RoleMappingResource roleMappingResource = user0Resource.roles();
        RoleScopeResource roleScopeResource = roleMappingResource.realmLevel();
        this.usersManager.assignRoles("user0", roles);
        ArgumentCaptor rolesCaptor = ArgumentCaptor.forClass(List.class);
        ((RoleScopeResource)Mockito.verify((Object)roleScopeResource, (VerificationMode)Mockito.times((int)1))).add((List)rolesCaptor.capture());
        List rolesAdded = (List)rolesCaptor.getValue();
        TestCase.assertEquals((int)2, (int)rolesAdded.size());
    }

    private void assertUser(User user, String username) {
        Assert.assertNotNull((Object)user);
        TestCase.assertEquals((String)username, (String)user.getIdentifier());
        Map attributes = user.getProperties();
        Assert.assertNotNull((Object)attributes);
        Assert.assertTrue((attributes.size() >= 4 ? 1 : 0) != 0);
        String id = (String)attributes.get("user.id");
        Assert.assertNotNull((Object)id);
        Assert.assertTrue((id.trim().length() > 0 ? 1 : 0) != 0);
        String firstName = (String)attributes.get("user.firstName");
        Assert.assertNotNull((Object)firstName);
        TestCase.assertEquals((String)username.toUpperCase(), (String)firstName);
        String lastName = (String)attributes.get("user.lastName");
        Assert.assertNotNull((Object)lastName);
        TestCase.assertEquals((String)(username.toUpperCase() + "Last"), (String)lastName);
        String enabled = (String)attributes.get("user.enabled");
        Assert.assertNotNull((Object)enabled);
        TestCase.assertEquals((String)enabled, (String)"true");
        String email = (String)attributes.get("user.email");
        Assert.assertNotNull((Object)email);
        TestCase.assertEquals((String)email, (String)(username + "@jboss.org"));
    }

    private void initUserManager() throws Exception {
        this.usersManager = (KeyCloakUserManager)Mockito.spy((Object)new KeyCloakUserManager());
        ((KeyCloakUserManager)Mockito.doReturn((Object)this.keycloakMock).when((Object)this.usersManager)).getKeyCloakInstance();
        this.usersManager.initialize(this.userSystemManager);
    }
}

