/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak.client.auth;

import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.keycloak.client.auth.BearerAuthenticationInterceptor;
import org.uberfire.ext.security.management.keycloak.client.auth.TokenManager;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthenticationClientExecutionInterceptorTest {
    @Mock
    TokenManager tokenManager;
    private BearerAuthenticationInterceptor interceptor;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.tokenManager.getAccessTokenString()).thenReturn((Object)"token1");
        this.interceptor = new BearerAuthenticationInterceptor(this.tokenManager);
    }

    @Test
    public void testExecute() throws Exception {
        ClientExecutionContext ctx = (ClientExecutionContext)Mockito.mock(ClientExecutionContext.class);
        ClientRequest request = (ClientRequest)Mockito.mock(ClientRequest.class);
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        Mockito.when((Object)ctx.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)ctx.proceed()).thenReturn((Object)response);
        ClientResponse response1 = this.interceptor.execute(ctx);
        ((ClientRequest)Mockito.verify((Object)request, (VerificationMode)Mockito.times((int)1))).header((String)Mockito.eq((Object)"Authorization"), Mockito.eq((Object)"Bearer token1"));
        Assert.assertEquals((Object)response, (Object)response1);
    }
}

