/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.tomcat;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jboss.errai.security.shared.api.Group;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.BaseTest;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.tomcat.TomcatGroupManager;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class TomcatGroupManagerTest
extends BaseTest {
    protected static final String ADMIN = "admin";
    protected static final String USERS_FILE_PATH = "org/uberfire/ext/security/management/tomcat/";
    protected static final String USERS_FILE_NAME = "tomcat-users.xml";
    @ClassRule
    public static TemporaryFolder tempFolder = new TemporaryFolder();
    private static File elHome;
    @Spy
    private TomcatGroupManager groupsManager = new TomcatGroupManager();

    @BeforeClass
    public static void initWorkspace() throws Exception {
        elHome = tempFolder.newFolder("uf-extensions-security-management-tomcat");
    }

    @Before
    public void setup() throws Exception {
        URL templateURL = Thread.currentThread().getContextClassLoader().getResource("org/uberfire/ext/security/management/tomcat/tomcat-users.xml");
        File templateFile = new File(templateURL.getFile());
        FileUtils.cleanDirectory((File)elHome);
        FileUtils.copyFileToDirectory((File)templateFile, (File)elHome);
        String full = new File(elHome, templateFile.getName()).getAbsolutePath();
        String path = full.substring(0, full.lastIndexOf(File.separator));
        String name = full.substring(full.lastIndexOf(File.separator) + 1, full.length());
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("org.uberfire.ext.security.management.tomcat.catalina-base", path);
        props.put("org.uberfire.ext.security.management.tomcat.users-file", name);
        System.setProperty("catalina.base", "");
        this.groupsManager.loadConfig(new ConfigProperties(props));
        this.groupsManager.initialize(this.userSystemManager);
    }

    @After
    public void finishIt() throws Exception {
        this.groupsManager.destroy();
    }

    @Test
    public void testCapabilities() {
        Assert.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_SEARCH_GROUPS), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_READ_GROUP), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_ADD_GROUP), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_DELETE_GROUP), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.groupsManager.getCapabilityStatus(Capability.CAN_UPDATE_GROUP), (Object)CapabilityStatus.UNSUPPORTED);
    }

    @Test
    public void testAllowsEmpty() {
        Assert.assertTrue((boolean)this.groupsManager.getSettings().allowEmpty());
    }

    @Test(expected=RuntimeException.class)
    public void testSearchPageZero() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 0, 5);
        AbstractEntityManager.SearchResponse response = this.groupsManager.search(request);
    }

    @Test
    public void testSearchAll() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 1, 5);
        AbstractEntityManager.SearchResponse response = this.groupsManager.search(request);
        Assert.assertNotNull((Object)response);
        List groups = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((long)total, (long)4L);
        Assert.assertTrue((!hasNextPage ? 1 : 0) != 0);
        Assert.assertEquals((long)groups.size(), (long)4L);
        List<Group> expectedGroups = this.createGroupList(ADMIN, "role3", "role2", "role1");
        Assert.assertEquals(new HashSet<Group>(expectedGroups), new HashSet(groups));
    }

    @Test
    public void testGet() {
        this.assertGet(ADMIN);
        this.assertGet("role1");
        this.assertGet("role2");
        this.assertGet("role3");
    }

    @Test
    public void testCreateGroup() {
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group.getName()).thenReturn((Object)"role10");
        this.groupsManager.create(group);
        Group created = this.groupsManager.get("role10");
        Assert.assertNotNull((Object)created);
        Assert.assertEquals((Object)"role10", (Object)created.getName());
    }

    @Test(expected=UnsupportedServiceCapabilityException.class)
    public void testUpdateGroup() {
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group.getName()).thenReturn((Object)"role10");
        this.groupsManager.update(group);
    }

    @Test(expected=GroupNotFoundException.class)
    public void testDeleteGroup() {
        this.groupsManager.delete(new String[]{"role3"});
        this.groupsManager.get("role3");
    }

    private List<Group> createGroupList(String ... names) {
        if (names != null) {
            ArrayList<Group> result = new ArrayList<Group>(names.length);
            for (int x = 0; x < names.length; ++x) {
                String name = names[x];
                Group g = SecurityManagementUtils.createGroup((String)name);
                result.add(g);
            }
            return result;
        }
        return null;
    }

    private void assertGet(String name) {
        Group group = this.groupsManager.get(name);
        Assert.assertNotNull((Object)group);
        Assert.assertEquals((Object)group.getName(), (Object)name);
    }
}

