/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.tomcat;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.BaseTest;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.tomcat.BaseTomcatManager;
import org.uberfire.ext.security.management.tomcat.TomcatUserManager;

@RunWith(value=MockitoJUnitRunner.class)
public class TomcatUserManagerTest
extends BaseTest {
    protected static final String ADMIN = "admin";
    protected static final String USERS_FILE_PATH = "org/uberfire/ext/security/management/tomcat/";
    protected static final String USERS_FILE_NAME = "tomcat-users.xml";
    @ClassRule
    public static TemporaryFolder tempFolder = new TemporaryFolder();
    private static File elHome;
    @Spy
    private TomcatUserManager usersManager = new TomcatUserManager();

    @BeforeClass
    public static void initWorkspace() throws Exception {
        elHome = tempFolder.newFolder("uf-extensions-security-management-tomcat");
        RoleRegistry.get().clear();
    }

    @Before
    public void setup() throws Exception {
        URL templateURL = Thread.currentThread().getContextClassLoader().getResource("org/uberfire/ext/security/management/tomcat/tomcat-users.xml");
        File templateFile = new File(templateURL.getFile());
        FileUtils.cleanDirectory((File)elHome);
        FileUtils.copyFileToDirectory((File)templateFile, (File)elHome);
        String full = new File(elHome, templateFile.getName()).getAbsolutePath();
        String path = full.substring(0, full.lastIndexOf(File.separator));
        String name = full.substring(full.lastIndexOf(File.separator) + 1, full.length());
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("org.uberfire.ext.security.management.tomcat.catalina-base", path);
        props.put("org.uberfire.ext.security.management.tomcat.users-file", name);
        System.setProperty("catalina.base", "");
        this.usersManager.loadConfig(new ConfigProperties(props));
        this.usersManager.initialize(this.userSystemManager);
    }

    @After
    public void finishIt() throws Exception {
        this.usersManager.destroy();
    }

    @Test
    public void testCapabilities() {
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_SEARCH_USERS), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_READ_USER), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_UPDATE_USER), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_ADD_USER), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_DELETE_USER), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_MANAGE_ATTRIBUTES), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_ASSIGN_GROUPS), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_CHANGE_PASSWORD), (Object)CapabilityStatus.ENABLED);
        Assert.assertEquals((Object)this.usersManager.getCapabilityStatus(Capability.CAN_ASSIGN_ROLES), (Object)CapabilityStatus.ENABLED);
    }

    @Test
    public void testAttributes() {
        List<UserManager.UserAttribute> USER_ATTRIBUTES = Arrays.asList(BaseTomcatManager.USER_FULLNAME);
        Collection attributes = this.usersManager.getSettings().getSupportedAttributes();
        Assert.assertEquals((Object)attributes, USER_ATTRIBUTES);
    }

    @Test(expected=RuntimeException.class)
    public void testSearchPageZero() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 0, 5);
        AbstractEntityManager.SearchResponse response = this.usersManager.search(request);
    }

    @Test
    public void testSearchAll() {
        AbstractEntityManager.SearchRequest request = this.buildSearchRequestMock("", 1, 5);
        AbstractEntityManager.SearchResponse response = this.usersManager.search(request);
        Assert.assertNotNull((Object)response);
        List users = response.getResults();
        int total = response.getTotal();
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((long)total, (long)4L);
        Assert.assertTrue((!hasNextPage ? 1 : 0) != 0);
        Assert.assertEquals((long)users.size(), (long)4L);
        HashSet<User> expectedUsers = new HashSet<User>(4);
        expectedUsers.add(this.create(ADMIN));
        expectedUsers.add(this.create("user1"));
        expectedUsers.add(this.create("user2"));
        expectedUsers.add(this.create("user3"));
        Assert.assertThat(new HashSet(users), (Matcher)CoreMatchers.is(expectedUsers));
    }

    @Test
    public void testGetAdmin() {
        User user = this.usersManager.get(ADMIN);
        this.assertUser(user, ADMIN);
    }

    @Test
    public void testGetUser1() {
        User user = this.usersManager.get("user1");
        this.assertUser(user, "user1");
    }

    @Test
    public void testGetUser2() {
        User user = this.usersManager.get("user2");
        this.assertUser(user, "user2");
    }

    @Test
    public void testGetUser3() {
        User user = this.usersManager.get("user3");
        this.assertUser(user, "user3");
    }

    @Test
    public void testGetAllUsers() {
        List users = this.usersManager.getAll();
        Assert.assertEquals((long)4L, (long)users.size());
    }

    @Test
    public void testCreateUser() {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user4");
        User userCreated = this.usersManager.create(user);
        this.assertUser(userCreated, "user4");
    }

    @Test
    public void testUpdateUser() {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("user.fullName", "user1 Full Name");
        Mockito.when((Object)user.getProperty("user.fullName")).thenReturn((Object)"user1 Full Name");
        Mockito.when((Object)user.getProperties()).thenReturn(properties);
        User userUpdated = this.usersManager.update(user);
        Assert.assertNotNull((Object)userUpdated);
        Assert.assertEquals((Object)"user1 Full Name", (Object)userUpdated.getProperty("user.fullName"));
    }

    @Test(expected=UserNotFoundException.class)
    public void testDeleteUser() {
        this.usersManager.delete(new String[]{"user1"});
        this.usersManager.get("user1");
    }

    @Test
    public void testAssignGroups() {
        final User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)user.getRoles()).thenReturn(new HashSet());
        UserManager userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        ((UserManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return user;
            }
        }).when((Object)userManagerMock)).get("user1");
        Mockito.when((Object)this.userSystemManager.users()).thenReturn((Object)userManagerMock);
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("role1");
        groups.add("role3");
        this.usersManager.assignGroups("user1", groups);
        Set result = this.usersManager.get("user1").getGroups();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testAssignRoles() {
        RoleRegistry.get().registerRole("role1");
        RoleRegistry.get().registerRole("role3");
        final User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)user.getGroups()).thenReturn(new HashSet());
        UserManager userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        ((UserManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return user;
            }
        }).when((Object)userManagerMock)).get("user1");
        Mockito.when((Object)this.userSystemManager.users()).thenReturn((Object)userManagerMock);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("role1");
        roles.add("role3");
        this.usersManager.assignRoles("user1", roles);
        Set result = this.usersManager.get("user1").getRoles();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testAssignRolesNotAllRegistered() {
        RoleRegistry.get().registerRole("role1");
        final User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)user.getGroups()).thenReturn(new HashSet());
        UserManager userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        ((UserManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return user;
            }
        }).when((Object)userManagerMock)).get("user1");
        Mockito.when((Object)this.userSystemManager.users()).thenReturn((Object)userManagerMock);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("role1");
        roles.add("role3");
        this.usersManager.assignRoles("user1", roles);
        Set result = this.usersManager.get("user1").getRoles();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testChangePassword() {
        this.usersManager.changePassword("user1", "newUser1Password");
        MemoryUserDatabase database = this.usersManager.getDatabase();
        org.apache.catalina.User catalinaUser = this.usersManager.getUser(database, "user1");
        Assert.assertEquals((Object)"newUser1Password", (Object)catalinaUser.getPassword());
    }

    private User create(String username) {
        return new UserImpl(username);
    }

    private void assertUser(User user, String username) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getIdentifier(), (Object)username);
    }
}

