/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.tomcat;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.catalina.Role;
import org.apache.catalina.users.MemoryUserDatabase;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.impl.UserAttributeImpl;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

public abstract class BaseTomcatManager {
    public static final String DEFAULT_CATALINA_BASE = "/opt/tomcat";
    public static final String USERS_FILE = "conf/tomcat-users.xml";
    public static final String DATABASE_NAME = "UserDatabase";
    public static final String ATTRIBUTE_USER_FULLNAME = "user.fullName";
    protected static final String CATALINA_BASE_PROPERTY = "catalina.base";
    protected static final UserManager.UserAttribute USER_FULLNAME = new UserAttributeImpl("user.fullName", false, true, "Full name");
    protected static final Collection<UserManager.UserAttribute> USER_ATTRIBUTES = Arrays.asList(USER_FULLNAME);
    private static final Logger LOG = LoggerFactory.getLogger(BaseTomcatManager.class);
    protected String defaultCatalinaBase = "/opt/tomcat";
    protected String usersFile = "conf/tomcat-users.xml";

    protected static boolean isConfigPropertySet(ConfigProperties.ConfigProperty property) {
        if (property == null) {
            return false;
        }
        String value = property.getValue();
        return !BaseTomcatManager.isEmpty(value);
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected void loadConfig(ConfigProperties config) {
        ConfigProperties.ConfigProperty catalinaBasePath = config.get("org.uberfire.ext.security.management.tomcat.catalina-base", DEFAULT_CATALINA_BASE);
        ConfigProperties.ConfigProperty usersName = config.get("org.uberfire.ext.security.management.tomcat.users-file", USERS_FILE);
        if (!BaseTomcatManager.isConfigPropertySet(catalinaBasePath)) {
            throw new IllegalArgumentException("Property 'org.uberfire.ext.security.management.tomcat.catalina-base' is mandatory and not set.");
        }
        if (!BaseTomcatManager.isConfigPropertySet(usersName)) {
            throw new IllegalArgumentException("Property 'org.uberfire.ext.security.management.tomcat.users-file' is mandatory and not set.");
        }
        this.defaultCatalinaBase = catalinaBasePath.getValue();
        this.usersFile = usersName.getValue();
        this.initializeTomcatProperties();
    }

    protected void initializeTomcatProperties() {
        if (BaseTomcatManager.isEmpty(System.getProperty(CATALINA_BASE_PROPERTY))) {
            System.setProperty(CATALINA_BASE_PROPERTY, this.defaultCatalinaBase);
        }
    }

    protected MemoryUserDatabase getDatabase() throws SecurityManagementException {
        MemoryUserDatabase database = new MemoryUserDatabase(DATABASE_NAME);
        database.setPathname(this.usersFile);
        database.setReadonly(false);
        try {
            database.open();
            if (!database.getReadonly()) {
                database.save();
            }
        }
        catch (Exception e) {
            throw new SecurityManagementException((Throwable)e);
        }
        return database;
    }

    protected void saveDatabase(MemoryUserDatabase database) throws SecurityManagementException {
        try {
            database.save();
        }
        catch (Exception e) {
            throw new SecurityManagementException((Throwable)e);
        }
    }

    protected void closeDatabase(MemoryUserDatabase database) throws SecurityManagementException {
        try {
            database.close();
        }
        catch (Exception e) {
            throw new SecurityManagementException((Throwable)e);
        }
    }

    protected org.apache.catalina.User getUser(MemoryUserDatabase database, String identifier) {
        org.apache.catalina.User user = database.findUser(identifier);
        if (user == null) {
            throw new UserNotFoundException(identifier);
        }
        return user;
    }

    protected Role getRole(MemoryUserDatabase database, String identifier) {
        Role group = database.findRole(identifier);
        if (group == null) {
            throw new GroupNotFoundException(identifier);
        }
        return group;
    }

    protected User createUser(org.apache.catalina.User user, Iterator<Role> groups) {
        if (user == null) {
            return null;
        }
        HashSet _groups = new HashSet();
        HashSet _roles = new HashSet();
        Set registeredRoles = SecurityManagementUtils.getRegisteredRoleNames();
        if (groups != null && groups.hasNext()) {
            while (groups.hasNext()) {
                Role group = groups.next();
                String name = group.getRolename();
                SecurityManagementUtils.populateGroupOrRoles((String)name, (Set)registeredRoles, _groups, _roles);
            }
        }
        return SecurityManagementUtils.createUser((String)user.getName(), _groups, _roles);
    }

    protected Group createGroup(Role group) {
        if (group == null) {
            return null;
        }
        return SecurityManagementUtils.createGroup((String)group.getRolename());
    }

    protected org.jboss.errai.security.shared.api.Role createRole(Role group) {
        if (group == null) {
            return null;
        }
        return SecurityManagementUtils.createRole((String)group.getRolename());
    }
}

