/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.tomcat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.users.MemoryUserDatabase;
import org.jboss.errai.security.shared.api.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.impl.GroupManagerSettingsImpl;
import org.uberfire.ext.security.management.search.GroupsIdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.IdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.tomcat.BaseTomcatManager;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

public class TomcatGroupManager
extends BaseTomcatManager
implements GroupManager,
ContextualManager {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatGroupManager.class);
    IdentifierRuntimeSearchEngine<Group> groupsSearchEngine;

    public TomcatGroupManager() {
        this(new ConfigProperties(System.getProperties()));
    }

    public TomcatGroupManager(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public TomcatGroupManager(ConfigProperties gitPrefs) {
        this.loadConfig(gitPrefs);
    }

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.groupsSearchEngine = new GroupsIdentifierRuntimeSearchEngine();
    }

    public void destroy() throws Exception {
    }

    public AbstractEntityManager.SearchResponse<Group> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        List<Group> groups = this.getAll();
        return this.groupsSearchEngine.search(groups, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group get(String identifier) throws SecurityManagementException {
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            Role group = this.getRole(userDatabase, identifier);
            Group group2 = this.createGroup(group);
            return group2;
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getAll() throws SecurityManagementException {
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            Iterator groupIterator = userDatabase.getRoles();
            ArrayList<Group> groups = new ArrayList<Group>();
            if (groupIterator != null) {
                while (groupIterator.hasNext()) {
                    Role group = (Role)groupIterator.next();
                    Group groupname = SecurityManagementUtils.createGroup((String)group.getRolename());
                    groups.add(groupname);
                }
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group create(Group entity) throws SecurityManagementException {
        if (entity == null) {
            throw new NullPointerException();
        }
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            String name = entity.getName();
            userDatabase.createRole(name, name);
            this.saveDatabase(userDatabase);
            Group group = entity;
            return group;
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    public Group update(Group entity) throws SecurityManagementException {
        throw new UnsupportedServiceCapabilityException(Capability.CAN_UPDATE_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String ... identifiers) throws SecurityManagementException {
        if (identifiers == null) {
            throw new NullPointerException();
        }
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            for (String identifier : identifiers) {
                Role group = this.getRole(userDatabase, identifier);
                userDatabase.removeRole(group);
            }
            this.saveDatabase(userDatabase);
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    public GroupManagerSettings getSettings() {
        HashMap<Capability, CapabilityStatus> capabilityStatusMap = new HashMap<Capability, CapabilityStatus>(8);
        for (Capability capability : SecurityManagementUtils.GROUPS_CAPABILITIES) {
            capabilityStatusMap.put(capability, this.getCapabilityStatus(capability));
        }
        return new GroupManagerSettingsImpl(capabilityStatusMap, true);
    }

    protected CapabilityStatus getCapabilityStatus(Capability capability) {
        if (capability != null) {
            switch (capability) {
                case CAN_SEARCH_GROUPS: 
                case CAN_ADD_GROUP: 
                case CAN_READ_GROUP: 
                case CAN_DELETE_GROUP: {
                    return CapabilityStatus.ENABLED;
                }
            }
        }
        return CapabilityStatus.UNSUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignUsers(String name, Collection<String> users) throws SecurityManagementException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (users != null) {
            MemoryUserDatabase userDatabase = this.getDatabase();
            Role role = this.getRole(userDatabase, name);
            try {
                for (String username : users) {
                    User user = this.getUser(userDatabase, username);
                    user.addRole(role);
                }
                this.saveDatabase(userDatabase);
            }
            finally {
                this.closeDatabase(userDatabase);
            }
        }
    }
}

