/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly8.properties;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.wildfly.properties.BaseWildflyGroupPropertiesManager;
import org.uberfire.ext.security.management.wildfly.properties.WildflyPropertiesFileLoader;

public class Wildfly8GroupPropertiesManager
extends BaseWildflyGroupPropertiesManager
implements GroupManager,
ContextualManager {
    private static final Logger LOG = LoggerFactory.getLogger(Wildfly8GroupPropertiesManager.class);

    public Wildfly8GroupPropertiesManager() {
    }

    public Wildfly8GroupPropertiesManager(Map<String, String> gitPrefs) {
        super(gitPrefs);
    }

    public Wildfly8GroupPropertiesManager(ConfigProperties gitPrefs) {
        super(gitPrefs);
    }

    protected WildflyPropertiesFileLoader getFileLoader(String filePath) {
        PropertiesFileLoader propertiesFileLoader;
        File propertiesFile = new File(filePath);
        if (!propertiesFile.exists()) {
            throw new RuntimeException("Cannot load roles/groups properties file from '" + filePath + "'.");
        }
        try {
            propertiesFileLoader = new PropertiesFileLoader(propertiesFile.getCanonicalPath());
            propertiesFileLoader.start(null);
        }
        catch (Exception e) {
            LOG.error("Error getting properties file.", (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
        return new WildflyPropertiesFileLoader(){

            public Properties getProperties() throws IOException {
                return propertiesFileLoader.getProperties();
            }

            public void persistProperties() throws IOException {
                propertiesFileLoader.persistProperties();
            }

            public void stop() {
                propertiesFileLoader.stop(null);
            }
        };
    }

    protected String generateHashPassword(String username, String realm, String password) {
        String result = null;
        try {
            result = new UsernamePasswordHashUtil().generateHashedHexURP(username, realm, password.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }
}

