/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly8.properties;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.domain.management.security.UserPropertiesFileLoader;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.wildfly.properties.BaseWildflyUserPropertiesManager;
import org.uberfire.ext.security.management.wildfly.properties.WildflyPropertiesFileLoader;

public class Wildfly8UserPropertiesManager
extends BaseWildflyUserPropertiesManager
implements UserManager,
ContextualManager {
    public Wildfly8UserPropertiesManager() {
    }

    public Wildfly8UserPropertiesManager(Map<String, String> gitPrefs) {
        super(gitPrefs);
    }

    public Wildfly8UserPropertiesManager(ConfigProperties gitPrefs) {
        super(gitPrefs);
    }

    protected WildflyPropertiesFileLoader buildFileLoader(String usersFilePath) throws Exception {
        File usersFile = new File(usersFilePath);
        if (!usersFile.exists()) {
            throw new RuntimeException("Properties file for users not found at '" + usersFilePath + "'.");
        }
        final UserPropertiesFileLoader usersFileLoader = new UserPropertiesFileLoader(usersFile.getAbsolutePath());
        try {
            usersFileLoader.start(null);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new WildflyPropertiesFileLoader(){

            public Properties getProperties() throws IOException {
                return usersFileLoader.getProperties();
            }

            public void persistProperties() throws IOException {
                usersFileLoader.persistProperties();
            }

            public void stop() {
                usersFileLoader.stop(null);
            }
        };
    }

    protected String generateHashPassword(String username, String realm, String password) {
        String result = null;
        try {
            result = new UsernamePasswordHashUtil().generateHashedHexURP(username, realm, password.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }
}

